/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.SimpleTrailReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.SimpleTrailWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.AbstractDataContainerFileWriter;
import adams.flow.transformer.TrailFileReader;
import adams.flow.transformer.TrailFileWriter;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TrailFileReaderTest
extends AbstractFlowTest {
    public TrailFileReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("mouse1.trail");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.trail");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("mouse1.trail");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.trail");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.trail")});
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[]{0};
    }

    public static Test suite() {
        return new TestSuite(TrailFileReaderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/mouse1.trail"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            TrailFileReader trailfilereader = new TrailFileReader();
            SimpleTrailReader simpletrailreader = new SimpleTrailReader();
            trailfilereader.setReader((AbstractDataContainerReader)simpletrailreader);
            actors.add(trailfilereader);
            TrailFileWriter trailfilewriter = new TrailFileWriter();
            SimpleTrailWriter simpletrailwriter = new SimpleTrailWriter();
            trailfilewriter.setWriter((AbstractDataContainerWriter)simpletrailwriter);
            argOption = (AbstractArgumentOption)trailfilewriter.getOptionManager().findByProperty("outputDir");
            trailfilewriter.setOutputDir((PlaceholderDirectory)argOption.valueOf("${TMP}"));
            argOption = (AbstractArgumentOption)trailfilewriter.getOptionManager().findByProperty("fileNameGeneration");
            trailfilewriter.setFileNameGeneration((AbstractDataContainerFileWriter.FileNameGeneration)argOption.valueOf("SUPPLIED"));
            argOption = (AbstractArgumentOption)trailfilewriter.getOptionManager().findByProperty("suppliedFileName");
            trailfilewriter.setSuppliedFileName((String)argOption.valueOf("dumpfile.trail"));
            actors.add(trailfilewriter);
            flow.setActors(actors.toArray(new AbstractActor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            TrailFileReaderTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TrailFileReaderTest.runTest((Test)TrailFileReaderTest.suite());
    }
}

