/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.core.Range;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.GzipUtils;
import adams.data.DateFormatString;
import adams.data.container.DataPoint;
import adams.data.image.BufferedImageHelper;
import adams.data.image.IntArrayMatrixView;
import adams.data.io.input.AbstractTrailReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.output.SimpleTrailWriter;
import adams.data.report.Report;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseFloatDataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleTrailReader
extends AbstractTrailReader {
    private static final long serialVersionUID = 1681189490537858223L;

    public String globalInfo() {
        return "Reads trails in simple CSV-like format.\nSee " + SimpleTrailWriter.class.getName() + " for more details on format.";
    }

    public String getFormatDescription() {
        return new SimpleTrailWriter().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleTrailWriter().getFormatExtensions();
    }

    protected void readData() {
        List lines = FileUtils.loadFromFile((File)this.m_Input.getAbsoluteFile());
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<String> background = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        boolean header = true;
        for (String line : lines) {
            if (header) {
                if (line.startsWith("# ")) {
                    comments.add(line);
                    continue;
                }
                if (line.startsWith("% ")) {
                    background.add(line.substring("% ".length()));
                    continue;
                }
                header = false;
                data.add(line);
                continue;
            }
            data.add(line);
        }
        StringReader sreader = new StringReader(Utils.flatten(data, (String)"\n"));
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setDataRowType((DataRow)new DenseFloatDataRow());
        reader.setComment("#");
        reader.setMissingValue("");
        reader.setDateTimeMsecColumns(new Range("first"));
        reader.setDateTimeMsecLenient(true);
        reader.setDateTimeMsecFormat(new DateFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
        SpreadSheet sheet = reader.read((Reader)sreader);
        if (sheet == null) {
            this.getLogger().severe("Failed to read file from: " + this.m_Input);
            return;
        }
        Report report = Report.parseProperties((Properties)Properties.fromComment((String)Utils.flatten(comments, (String)"\n")));
        Trail trail = new Trail();
        for (Row row : sheet.rows()) {
            Step step = new Step((Date)row.getCell(0).toDateTimeMsec(), row.getCell(1).toDouble().floatValue(), row.getCell(2).toDouble().floatValue());
            trail.add((DataPoint)step);
        }
        trail.setReport(report);
        if (background.size() > 0) {
            byte[] uncompressed;
            int y;
            int width = Integer.parseInt(((String)background.remove(0)).trim());
            int height = Integer.parseInt(((String)background.remove(0)).trim());
            TByteArrayList compressed = new TByteArrayList();
            for (y = 0; y < background.size(); ++y) {
                byte[] pixels = Utils.fromHexArray((String)((String)background.get(y)));
                compressed.add(pixels);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("compressed background bytes: " + compressed.size());
            }
            if ((uncompressed = GzipUtils.decompress((byte[])compressed.toArray(), (int)1024)) != null) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("uncompressed background bytes: " + uncompressed.length);
                }
                IntArrayMatrixView matrix = new IntArrayMatrixView(width, height);
                for (y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int offset = y * width * 4 + x * 4;
                        int pixel = BufferedImageHelper.combine((int)uncompressed[offset], (int)uncompressed[offset + 1], (int)uncompressed[offset + 2], (int)uncompressed[offset + 3]);
                        matrix.set(x, y, pixel);
                    }
                }
                trail.setBackground(matrix.toBufferedImage(2));
            }
        }
        this.m_ReadData.add(trail);
    }
}

