/*
 * Decompiled with CFR 0.152.
 */
package adams.data.trail;

import adams.core.DateTimeMsec;
import adams.core.option.OptionUtils;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataContainer;
import adams.data.container.DataPointComparator;
import adams.data.image.BufferedImageHelper;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.statistics.InformativeStatisticSupporter;
import adams.data.trail.Step;
import adams.data.trail.StepComparator;
import adams.data.trail.TrailStatistic;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class Trail
extends AbstractDataContainer<Step>
implements MutableReportHandler<Report>,
NotesHandler,
SpreadSheetSupporter,
InformativeStatisticSupporter<TrailStatistic> {
    private static final long serialVersionUID = 8721248965909493612L;
    public static final String FIELD_WIDTH = "Trail.Width";
    public static final String FIELD_HEIGHT = "Trail.Height";
    protected Report m_Report;
    protected Notes m_Notes;
    protected Step m_MinX;
    protected Step m_MaxX;
    protected Step m_MinY;
    protected Step m_MaxY;
    protected BufferedImage m_Background;
    protected static StepComparator m_Comparator;

    public Trail() {
        this.m_ID = "" + new Date();
        this.m_Report = new Report();
        this.m_Notes = new Notes();
        this.m_Background = null;
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
    }

    public StepComparator newComparator() {
        return new StepComparator();
    }

    public DataPointComparator<Step> getComparator() {
        return m_Comparator;
    }

    public Step newPoint() {
        return new Step();
    }

    public void assign(DataContainer<Step> other) {
        super.assign(other);
        Trail trail = (Trail)other;
        if (trail.hasBackground()) {
            this.setBackground(BufferedImageHelper.deepCopy((BufferedImage)trail.getBackground()));
        } else {
            this.setBackground(null);
        }
        if (trail.hasReport()) {
            this.setReport(trail.getReport().getClone());
        } else {
            this.setReport(new Report());
        }
        this.m_Notes = new Notes();
        this.m_Notes.mergeWith(trail.getNotes());
    }

    protected boolean modifiedListener(boolean modified) {
        if (modified) {
            this.invalidateMinMax();
        }
        return modified;
    }

    protected synchronized void invalidateMinMax() {
        this.m_MinX = null;
        this.m_MaxX = null;
        this.m_MinY = null;
        this.m_MaxY = null;
    }

    protected synchronized void validateMinMax() {
        if (this.m_MinX != null) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)((Object)iterator.next());
            if (this.m_MaxX == null || step.getX() > this.m_MaxX.getX()) {
                this.m_MaxX = step;
            }
            if (this.m_MinX == null || step.getX() < this.m_MinX.getX()) {
                this.m_MinX = step;
            }
            if (this.m_MaxY == null || step.getY() > this.m_MaxY.getY()) {
                this.m_MaxY = step;
            }
            if (this.m_MinY != null && !(step.getY() < this.m_MinY.getY())) continue;
            this.m_MinY = step;
        }
    }

    public Step getMinX() {
        this.validateMinMax();
        return this.m_MinX;
    }

    public Step getMaxX() {
        this.validateMinMax();
        return this.m_MaxX;
    }

    public Step getMinY() {
        this.validateMinMax();
        return this.m_MinY;
    }

    public Step getMaxY() {
        this.validateMinMax();
        return this.m_MaxY;
    }

    public boolean hasWidth() {
        return this.hasReport() && this.getReport().hasValue(FIELD_WIDTH);
    }

    public void setWidth(Float value) {
        if (this.hasReport()) {
            if (value == null) {
                this.getReport().removeValue((AbstractField)new Field(FIELD_WIDTH, DataType.NUMERIC));
            } else {
                this.getReport().setNumericValue(FIELD_WIDTH, value.doubleValue());
            }
        }
    }

    public Float getWidth() {
        if (this.hasWidth()) {
            return Float.valueOf(this.getReport().getDoubleValue(FIELD_WIDTH).floatValue());
        }
        return null;
    }

    public boolean hasHeight() {
        return this.hasReport() && this.getReport().hasValue(FIELD_HEIGHT);
    }

    public void setHeight(Float value) {
        if (this.hasReport()) {
            if (value == null) {
                this.getReport().removeValue((AbstractField)new Field(FIELD_HEIGHT, DataType.NUMERIC));
            } else {
                this.getReport().setNumericValue(FIELD_HEIGHT, value.doubleValue());
            }
        }
    }

    public Float getHeight() {
        if (this.hasWidth()) {
            return Float.valueOf(this.getReport().getDoubleValue(FIELD_HEIGHT).floatValue());
        }
        return null;
    }

    public boolean hasBackground() {
        return this.m_Background != null;
    }

    public void setBackground(BufferedImage value) {
        this.m_Background = value;
    }

    public BufferedImage getBackground() {
        return this.m_Background;
    }

    public void newBackground() {
        this.newBackground(Color.WHITE);
    }

    public void newBackground(Color bgcolor) {
        int height;
        int width = this.getWidth().intValue();
        if (width <= 0) {
            width = (int)this.getMaxX().getX() + 10;
        }
        if ((height = this.getHeight().intValue()) <= 0) {
            height = (int)this.getMaxY().getY() + 10;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics g = image.getGraphics();
        g.setColor(bgcolor);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
        this.setBackground(image);
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public void setReport(Report value) {
        this.m_Report = value;
        if (this.m_Report != null) {
            this.m_Report.addField((AbstractField)new Field(FIELD_WIDTH, DataType.NUMERIC));
            this.m_Report.addField((AbstractField)new Field(FIELD_HEIGHT, DataType.NUMERIC));
        }
    }

    public boolean hasReport() {
        return this.m_Report != null;
    }

    public Report getReport() {
        return this.m_Report;
    }

    public SpreadSheet toSpreadSheet() {
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(DenseDataRow.class);
        result.setName(this.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("T").setContent("Timestamp");
        row.addCell("X").setContent("X");
        row.addCell("Y").setContent("Y");
        row.addCell("M").setContent("Meta-data");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)((Object)iterator.next());
            row = result.addRow();
            row.addCell("T").setContent(new DateTimeMsec(step.getTimestamp()));
            row.addCell("X").setContent(Float.valueOf(step.getX()));
            row.addCell("Y").setContent(Float.valueOf(step.getY()));
            if (!step.hasMetaData()) continue;
            ArrayList<String> meta = new ArrayList<String>();
            for (String key : step.getMetaData().keySet()) {
                meta.add(key + "=" + step.getMetaData().get(key));
            }
            row.addCell("M").setContentAsString(OptionUtils.joinOptions((String[])meta.toArray(new String[meta.size()])));
        }
        return result;
    }

    public TrailStatistic toStatistic() {
        return new TrailStatistic(this);
    }

    public String toString() {
        return "ID=" + this.getID() + ", width=" + (this.hasWidth() ? this.getWidth() : "-none") + ", height=" + (this.hasHeight() ? this.getHeight() : "-none") + ", #points=" + this.size();
    }
}

