/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.trail.Trail;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.trail.TrailPanel;
import adams.gui.visualization.trail.overlay.AbstractTrailOverlay;
import adams.gui.visualization.trail.paintlet.Circles;
import adams.gui.visualization.trail.paintlet.TrailPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;

public class TrailDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -5963541661512220421L;
    protected TrailPaintlet m_Paintlet;
    protected AbstractTrailOverlay[] m_Overlays;
    protected double m_Zoom;

    public String globalInfo() {
        return "Actor that displays trails.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new Circles());
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractTrailOverlay[0]);
        this.m_OptionManager.add("zoom", "zoom", (Object)-1.0, (Number)-1.0, (Number)1600.0);
    }

    protected int getDefaultWidth() {
        return 1000;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setPaintlet(TrailPaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public TrailPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for drawing the trail.";
    }

    public void setOverlays(AbstractTrailOverlay[] value) {
        this.m_Overlays = value;
        this.reset();
    }

    public AbstractTrailOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The overlay(s) to use.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"paintlet", (Object)this.m_Paintlet, (String)", paintlet: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"zoom", (Object)this.m_Zoom, (String)", zoom: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            ((TrailPanel)this.m_Panel).setTrail(null);
        }
    }

    protected BasePanel newPanel() {
        TrailPanel result = new TrailPanel(null);
        result.setPaintlet((TrailPaintlet)this.m_Paintlet.shallowCopy());
        for (AbstractTrailOverlay overlay : this.m_Overlays) {
            result.addOverlay(overlay);
        }
        if (this.m_Zoom == -1.0) {
            result.setZoom(-1.0);
        } else {
            result.setZoom(this.m_Zoom / 100.0);
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Trail.class};
    }

    protected void display(Token token) {
        ((TrailPanel)this.m_Panel).setTrail((Trail)((Object)token.getPayload()));
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -9139363702312636367L;
            protected TrailPanel m_TrailPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_TrailPanel = new TrailPanel(null);
                this.m_TrailPanel.setPaintlet((TrailPaintlet)TrailDisplay.this.m_Paintlet.shallowCopy());
                for (AbstractTrailOverlay overlay : TrailDisplay.this.m_Overlays) {
                    this.m_TrailPanel.addOverlay(overlay);
                }
                if (TrailDisplay.this.m_Zoom == -1.0) {
                    this.m_TrailPanel.setZoom(-1.0);
                } else {
                    this.m_TrailPanel.setZoom(TrailDisplay.this.m_Zoom / 100.0);
                }
                this.add((Component)((Object)this.m_TrailPanel), "Center");
            }

            public void display(Token token) {
                this.m_TrailPanel.setTrail((Trail)((Object)token.getPayload()));
            }

            public void cleanUp() {
            }

            public void clearPanel() {
            }

            public JComponent supplyComponent() {
                return this.m_TrailPanel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

