/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.ffmpeg;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.management.ProcessUtils;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.sink.FFmpeg;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractFFmpegPlugin
extends AbstractOptionHandler {
    private static final long serialVersionUID = -2555683041357914117L;
    protected FFmpeg m_Owner;
    protected PlaceholderFile m_Input;
    protected int m_BitRate;
    protected int m_FramesPerSecond;
    protected String m_AdditionalInputOptions;
    protected String m_AdditionalOutputOptions;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bit-rate", "bitRate", (Object)this.getDefaultBitRate(), (Number)1, null);
        this.m_OptionManager.add("fps", "framesPerSecond", (Object)this.getDefaultFramesPerSecond(), (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
    }

    protected void reset() {
        super.reset();
        this.m_Input = null;
    }

    public void setOwner(FFmpeg owner) {
        this.m_Owner = owner;
    }

    public FFmpeg getOwner() {
        return this.m_Owner;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"framesPerSecond", (Object)this.m_FramesPerSecond, (String)"-r ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bitRate", (Object)this.m_BitRate, (String)"-b ");
        return result;
    }

    protected int getDefaultFramesPerSecond() {
        return 25;
    }

    public void setFramesPerSecond(int value) {
        this.m_FramesPerSecond = value;
        this.reset();
    }

    public int getFramesPerSecond() {
        return this.m_FramesPerSecond;
    }

    public String framesPerSecondTipText() {
        return "The frames per second (in Hz).";
    }

    protected int getDefaultBitRate() {
        return 64000;
    }

    public void setBitRate(int value) {
        this.m_BitRate = value;
        this.reset();
    }

    public int getBitRate() {
        return this.m_BitRate;
    }

    public String bitRateTipText() {
        return "The bit rate (in kbits) to use.";
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    protected PlaceholderFile getExecutable() {
        if (this.m_Owner == null) {
            return null;
        }
        return this.m_Owner.getExecutable();
    }

    public String setUp() {
        String result = null;
        if (this.m_Owner == null) {
            result = "No owner set!";
        }
        return result;
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException((LoggingObject)this, (String)msg, (Throwable)t);
    }

    protected abstract String assembleInputOptions();

    protected abstract String assembleOutputOptions();

    public String execute() {
        String result = null;
        if (this.m_Input == null) {
            result = "No input file set!";
        }
        if (result == null) {
            ArrayList<String> options = new ArrayList<String>();
            try {
                ProcessUtils.ProcessResult proc;
                options.add(this.getExecutable().getAbsolutePath());
                options.add("-r");
                options.add("" + this.m_FramesPerSecond);
                options.add("-b");
                options.add("" + this.m_BitRate);
                options.add("-y");
                String cmd = this.assembleInputOptions();
                if (cmd.length() > 0) {
                    options.addAll(Arrays.asList(OptionUtils.splitOptions((String)cmd)));
                }
                options.add("-i");
                options.add(this.m_Input.getAbsolutePath());
                cmd = this.assembleOutputOptions();
                if (cmd.length() > 0) {
                    options.addAll(Arrays.asList(OptionUtils.splitOptions((String)cmd)));
                }
                options.add(this.getOwner().getOutputFile().getAbsolutePath());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Command-line: " + Utils.flatten(options, (String)" "));
                }
                if (!(proc = ProcessUtils.execute((String[])options.toArray(new String[options.size()]))).hasSucceeded()) {
                    result = proc.toErrorOutput();
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute commandline:\n" + Utils.flatten(options, (String)"\n"), e);
            }
        }
        this.m_Input = null;
        return result;
    }
}

