/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.flow.transformer.objecttracker.AbstractBoofCVObjectTracker;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class BoofCVTLD
extends AbstractBoofCVObjectTracker
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7061565466109634695L;

    public String globalInfo() {
        return "Tracking-Learning-Detection (TLD) [1] (a.k.a Predator) object tracker for video sequences.\nTLD tracks an object which is specified by a user using a rectangle. The description of the object is dynamically updated using P and N constraints.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Zdenek Kalal");
        result.setValue(TechnicalInformation.Field.TITLE, "Tracking-Learning-Detection");
        result.setValue(TechnicalInformation.Field.ORGANIZATION, "University of Surrey");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.MONTH, "April");
        result.setValue(TechnicalInformation.Field.NOTE, "Phd Thesis");
        return result;
    }

    @Override
    protected TrackerObjectQuad newTracker() {
        switch (this.m_ImageType) {
            case FLOAT_32: {
                return FactoryTrackerObjectQuad.tld(null, ImageFloat32.class);
            }
            case FLOAT_64: {
                return FactoryTrackerObjectQuad.tld(null, ImageFloat64.class);
            }
            case SIGNED_INT_16: {
                return FactoryTrackerObjectQuad.tld(null, ImageSInt16.class);
            }
            case SIGNED_INT_32: {
                return FactoryTrackerObjectQuad.tld(null, ImageSInt32.class);
            }
            case SIGNED_INT_64: {
                return FactoryTrackerObjectQuad.tld(null, ImageSInt64.class);
            }
            case SIGNED_INT_8: {
                return FactoryTrackerObjectQuad.tld(null, ImageSInt8.class);
            }
            case UNSIGNED_INT_16: {
                return FactoryTrackerObjectQuad.tld(null, ImageUInt16.class);
            }
            case UNSIGNED_INT_8: {
                return FactoryTrackerObjectQuad.tld(null, ImageUInt8.class);
            }
        }
        throw new IllegalStateException("Unhandled image type: " + this.m_ImageType);
    }
}

