/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.base.QuadrilateralLocation;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import java.awt.Point;

public class SelectObjectToTrack
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    protected Field m_Location;

    public String globalInfo() {
        return "Allows the user to select a region (ie object) to track.\nWhen also holding the CTRL key down, this will delete any selected region.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("location", "location", (Object)new Field("Tracker.Init", DataType.STRING));
    }

    public void setLocation(Field value) {
        this.m_Location = value;
        this.reset();
    }

    public Field getLocation() {
        return this.m_Location;
    }

    public String locationTipText() {
        return "The field to store the location of the object in.";
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        Report report = panel.getAdditionalProperties().getClone();
        if ((modifiersEx & 0x80) != 0) {
            report.removeValue((AbstractField)this.m_Location);
        } else {
            int x1 = panel.mouseToPixelLocation((Point)topLeft).x;
            int y1 = panel.mouseToPixelLocation((Point)topLeft).y;
            int x2 = panel.mouseToPixelLocation((Point)bottomRight).x;
            int y2 = panel.mouseToPixelLocation((Point)bottomRight).y;
            QuadrilateralLocation loc = new QuadrilateralLocation((double)x1, (double)y1, (double)x2, (double)y1, (double)x2, (double)y2, (double)x1, (double)y2);
            report.addField((AbstractField)this.m_Location);
            report.setValue((AbstractField)this.m_Location, (Object)loc.toString());
        }
        panel.setAdditionalProperties(report);
    }
}

