/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.GzipUtils;
import adams.data.image.BufferedImageHelper;
import adams.data.io.output.AbstractTrailWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Trail;
import gnu.trove.list.array.TByteArrayList;
import java.awt.image.BufferedImage;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class SimpleTrailWriter
extends AbstractTrailWriter {
    private static final long serialVersionUID = -7138302129366743189L;
    public static final String COMMENT = "# ";
    public static final String BACKGROUND = "% ";
    protected boolean m_StoreBackground;

    public String globalInfo() {
        return "Writes trails in the simple CSV-like format.\nThe report and trail image come before the actual trail data.\nThe report data is prefixed with '# ' and the background is prefixed with '% '.\nThe background data are the gzipped RGBA bytes of the image (obtained row-by-row from image).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("store-background", "storeBackground", (Object)true);
    }

    public void setStoreBackground(boolean value) {
        this.m_StoreBackground = value;
        this.reset();
    }

    public boolean getStoreBackground() {
        return this.m_StoreBackground;
    }

    public String storeBackgroundTipText() {
        return "If enabled, the background gets stored in the file as well.";
    }

    public String getFormatDescription() {
        return "Simple trail format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"trail"};
    }

    public boolean canWriteMultiple() {
        return false;
    }

    protected boolean writeData(List<Trail> data) {
        if (data.size() == 0) {
            return false;
        }
        Trail trail = data.get(0);
        StringWriter swriter = new StringWriter();
        if (trail.hasReport()) {
            Properties props = trail.getReport().toProperties();
            swriter.write(props.toComment());
        }
        if (this.getStoreBackground() && trail.hasBackground()) {
            int x;
            swriter.append(BACKGROUND + trail.getBackground().getWidth() + "\n");
            swriter.append(BACKGROUND + trail.getBackground().getHeight() + "\n");
            BufferedImage image = BufferedImageHelper.convert((BufferedImage)trail.getBackground(), (int)2);
            int[][] pixels = BufferedImageHelper.getRGBPixels((BufferedImage)image);
            TByteArrayList uncompressed = new TByteArrayList();
            for (int y = 0; y < pixels.length; ++y) {
                for (x = 0; x < pixels[y].length; ++x) {
                    uncompressed.add((byte)pixels[y][x]);
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("uncompressed background bytes: " + uncompressed.size());
            }
            byte[] compressed = GzipUtils.compress((byte[])uncompressed.toArray());
            if (this.isLoggingEnabled()) {
                this.getLogger().info("compressed background bytes: " + compressed.length);
            }
            StringBuilder row = new StringBuilder(BACKGROUND);
            for (x = 0; x < compressed.length; ++x) {
                if (x % 1000 == 0) {
                    if (row.length() > BACKGROUND.length()) {
                        row.append("\n");
                        swriter.append(row.toString());
                    }
                    row = new StringBuilder(BACKGROUND);
                }
                row.append(Utils.toHex((byte)compressed[x]));
            }
            if (row.length() > BACKGROUND.length()) {
                row.append("\n");
                swriter.append(row.toString());
            }
        }
        SpreadSheet sheet = trail.toSpreadSheet();
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        writer.setMissingValue("");
        boolean result = writer.write(sheet, (Writer)swriter);
        if (result) {
            result = FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)swriter.toString(), (boolean)false);
        }
        return result;
    }
}

