/*
 * Decompiled with CFR 0.152.
 */
package adams.data.trail;

import adams.data.container.DataContainer;
import adams.data.statistics.AbstractDataStatistic;
import adams.data.statistics.StatUtils;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import java.util.Date;
import java.util.List;

public class TrailStatistic
extends AbstractDataStatistic<Trail> {
    private static final long serialVersionUID = -2482267274581297567L;
    public static final String MIN_X = "min X";
    public static final String MAX_X = "max X";
    public static final String MIN_Y = "min Y";
    public static final String MAX_Y = "max Y";
    public static final String MEDIAN_DELTA_Y = "median delta Y";
    public static final String STDEV_DELTA_Y = "stdev delta Y";
    public static final String MEAN_DELTA_Y = "mean delta Y";
    public static final String MAX_DELTA_Y = "max delta Y";
    public static final String MIN_DELTA_Y = "min delta Y";
    public static final String MEDIAN_DELTA_X = "median delta X";
    public static final String STDEV_DELTA_X = "stdev delta X";
    public static final String MEAN_DELTA_X = "mean delta X";
    public static final String MAX_DELTA_X = "max delta X";
    public static final String MIN_DELTA_X = "min delta X";
    public static final String MEDIAN_DELTA_TIMESTAMP = "median delta timestamp";
    public static final String STDEV_DELTA_TIMESTAMP = "stdev delta timestampX";
    public static final String MEAN_DELTA_TIMESTAMP = "mean delta timestamp";
    public static final String MAX_DELTA_TIMESTAMP = "max delta timestamp";
    public static final String MIN_DELTA_TIMESTAMP = "min delta timestamp";
    public static final String LAST_TIMESTAMP = "Last timestamp (msec)";
    public static final String FIRST_TIMESTAMP = "First timestamp (msec)";
    public static final String NUMBER_OF_POINTS = "Number of points";

    public TrailStatistic() {
    }

    public TrailStatistic(Trail data) {
        super((DataContainer)data);
    }

    public String globalInfo() {
        return "Calculates a view statistics for a trail.";
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data = null;
    }

    public void setData(Trail value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public Trail getData() {
        return (Trail)this.m_Data;
    }

    public String getStatisticDescription() {
        return ((Trail)this.m_Data).getID();
    }

    protected void calculate() {
        super.calculate();
        if (this.m_Data == null) {
            return;
        }
        List points = ((Trail)this.m_Data).toList();
        Date firstTimestamp = new Date(0L);
        Date lastTimestamp = new Date(0L);
        Number[] deltaTimestamp = new Long[]{};
        Number[] deltaX = new Float[]{};
        Number[] deltaY = new Float[]{};
        if (points.size() > 0) {
            firstTimestamp = ((Step)((Object)points.get(0))).getTimestamp();
            if (points.size() > 1) {
                lastTimestamp = ((Step)((Object)points.get(points.size() - 1))).getTimestamp();
            }
            deltaX = new Float[points.size() - 1];
            deltaY = new Float[points.size() - 1];
            deltaTimestamp = new Long[points.size() - 1];
            for (int i = 0; i < points.size(); ++i) {
                if (i <= 0) continue;
                deltaX[i - 1] = Float.valueOf(((Step)((Object)points.get(i))).getX() - ((Step)((Object)points.get(i - 1))).getX());
                deltaY[i - 1] = Float.valueOf(((Step)((Object)points.get(i))).getY() - ((Step)((Object)points.get(i - 1))).getY());
                deltaTimestamp[i - 1] = ((Step)((Object)points.get(i))).getTimestamp().getTime() - ((Step)((Object)points.get(i - 1))).getTimestamp().getTime();
            }
        }
        this.add(NUMBER_OF_POINTS, points.size());
        this.add(FIRST_TIMESTAMP, firstTimestamp.getTime());
        this.add(LAST_TIMESTAMP, lastTimestamp.getTime());
        this.add(MIN_X, ((Trail)this.m_Data).getMinX().getX());
        this.add(MAX_X, ((Trail)this.m_Data).getMaxX().getX());
        this.add(MIN_Y, ((Trail)this.m_Data).getMinY().getY());
        this.add(MAX_Y, ((Trail)this.m_Data).getMaxY().getY());
        this.add(MIN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.min((Number[])deltaTimestamp)));
        this.add(MAX_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.max((Number[])deltaTimestamp)));
        this.add(MEAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.mean((Number[])deltaTimestamp)));
        this.add(STDEV_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.stddev((Number[])deltaTimestamp, (boolean)true)));
        this.add(MEDIAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.median((Number[])deltaTimestamp)));
        this.add(MIN_DELTA_X, this.numberToDouble(StatUtils.min((Number[])deltaX)));
        this.add(MAX_DELTA_X, this.numberToDouble(StatUtils.max((Number[])deltaX)));
        this.add(MEAN_DELTA_X, this.numberToDouble(StatUtils.mean((Number[])deltaX)));
        this.add(STDEV_DELTA_X, this.numberToDouble(StatUtils.stddev((Number[])deltaX, (boolean)true)));
        this.add(MEDIAN_DELTA_X, this.numberToDouble(StatUtils.median((Number[])deltaX)));
        this.add(MIN_DELTA_Y, this.numberToDouble(StatUtils.min((Number[])deltaY)));
        this.add(MAX_DELTA_Y, this.numberToDouble(StatUtils.max((Number[])deltaY)));
        this.add(MEAN_DELTA_Y, this.numberToDouble(StatUtils.mean((Number[])deltaY)));
        this.add(STDEV_DELTA_Y, this.numberToDouble(StatUtils.stddev((Number[])deltaY, (boolean)true)));
        this.add(MEDIAN_DELTA_Y, this.numberToDouble(StatUtils.median((Number[])deltaY)));
    }
}

