/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import java.util.List;

public class WebcamInfo
extends AbstractSimpleSource
implements DataInfoActor {
    private static final long serialVersionUID = -5718059337341470131L;
    protected String m_Webcam;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs info on webcams.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("webcam", "webcam", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)InfoType.AVAILABLE_RESOLUTIONS);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"webcam", (Object)(this.m_Webcam.isEmpty() ? "-default-" : this.m_Webcam), (String)"webcam: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case RESOLUTION: 
            case AVAILABLE_RESOLUTIONS: {
                return new Class[]{SpreadSheet.class};
            }
            case IS_OPEN: {
                return new Class[]{Boolean.class};
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    public void setWebcam(String value) {
        this.m_Webcam = value;
        this.reset();
    }

    public String getWebcam() {
        return this.m_Webcam;
    }

    public String webcamTipText() {
        return "The webcam name (leave empty for default one).";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    protected String doExecute() {
        String result = null;
        try {
            Webcam cam = null;
            if (this.m_Webcam.trim().isEmpty()) {
                cam = Webcam.getDefault();
            } else {
                List webcams = Webcam.getWebcams();
                for (Webcam webcam : webcams) {
                    if (!webcam.getName().equals(this.m_Webcam)) continue;
                    cam = webcam;
                    break;
                }
                if (cam == null) {
                    result = "Failed to locate webcam '" + this.m_Webcam + "'!";
                }
            }
            if (cam != null) {
                switch (this.m_Type) {
                    case RESOLUTION: {
                        SpreadSheet sheet = new SpreadSheet();
                        HeaderRow row = sheet.getHeaderRow();
                        row.addCell("W").setContent("Width");
                        row.addCell("H").setContent("Height");
                        Dimension dim = cam.getViewSize();
                        if (dim != null) {
                            row = sheet.addRow();
                            row.addCell("W").setContent(Double.valueOf(dim.getWidth()));
                            row.addCell("H").setContent(Double.valueOf(dim.getHeight()));
                        } else {
                            this.getLogger().warning("Failed to retrieve current resolution - webcam not yet open?");
                        }
                        this.m_OutputToken = new Token((Object)sheet);
                        break;
                    }
                    case AVAILABLE_RESOLUTIONS: {
                        SpreadSheet sheet = new SpreadSheet();
                        HeaderRow row = sheet.getHeaderRow();
                        row.addCell("W").setContent("Width");
                        row.addCell("H").setContent("Height");
                        for (Dimension d : cam.getViewSizes()) {
                            row = sheet.addRow();
                            row.addCell("W").setContent(Double.valueOf(d.getWidth()));
                            row.addCell("H").setContent(Double.valueOf(d.getHeight()));
                        }
                        this.m_OutputToken = new Token((Object)sheet);
                        break;
                    }
                    case IS_OPEN: {
                        this.m_OutputToken = new Token((Object)cam.isOpen());
                        break;
                    }
                    default: {
                        result = "Unhandled info type: " + (Object)((Object)this.m_Type);
                    }
                }
            }
        }
        catch (Throwable e) {
            result = this.handleException("Failed to get webcam info:", e);
        }
        return result;
    }

    public static enum InfoType {
        RESOLUTION,
        AVAILABLE_RESOLUTIONS,
        IS_OPEN;

    }
}

