/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IError;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@MixedCopyright(author="Xuggle-Xuggler-Main", license=License.LGPL3, url="http://xuggle.googlecode.com/svn/trunk/java/xuggle-xuggler/src/com/xuggle/mediatool/demos/DecodeAndCaptureFrames.java")
public class MovieImageSequence
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    protected int m_Interval;
    protected transient IMediaReader m_Reader;
    protected transient MediaListenerAdapter m_Listener;
    protected long m_LastPtsWrite;
    protected long m_MicroSecondsBetweenFrames;
    protected int m_VideoStreamIndex;

    public String globalInfo() {
        return "Streams the individual frames from a video file obtained as input.\nImages are output as " + BufferedImage.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", (Object)1000);
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval in milli-seconds to wait before continuing with the execution.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"interval", (Object)this.m_Interval) + "ms";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_LastPtsWrite = Global.NO_PTS;
        this.m_VideoStreamIndex = -1;
        this.m_MicroSecondsBetweenFrames = Global.DEFAULT_PTS_PER_SECOND * (long)this.m_Interval / 1000L;
        Object payload = this.m_InputToken.getPayload();
        String filename = this.m_InputToken.getPayload() instanceof String ? (String)this.m_InputToken.getPayload() : ((File)this.m_InputToken.getPayload()).getAbsolutePath();
        PlaceholderFile file = new PlaceholderFile(filename);
        try {
            this.m_Reader = ToolFactory.makeReader((String)file.getAbsolutePath());
            this.m_Reader.setBufferedImageTypeToGenerate(5);
            this.m_Listener = new MediaListenerAdapter(){

                public void onVideoPicture(IVideoPictureEvent event) {
                    try {
                        if (event.getStreamIndex() != MovieImageSequence.this.m_VideoStreamIndex) {
                            if (MovieImageSequence.this.m_VideoStreamIndex == -1) {
                                MovieImageSequence.this.m_VideoStreamIndex = event.getStreamIndex();
                            } else {
                                return;
                            }
                        }
                        if (MovieImageSequence.this.m_LastPtsWrite == Global.NO_PTS) {
                            MovieImageSequence.this.m_LastPtsWrite = event.getTimeStamp() - MovieImageSequence.this.m_MicroSecondsBetweenFrames;
                        }
                        if (event.getTimeStamp() - MovieImageSequence.this.m_LastPtsWrite >= MovieImageSequence.this.m_MicroSecondsBetweenFrames) {
                            BufferedImageContainer cont = new BufferedImageContainer();
                            cont.setImage((Object)event.getImage());
                            Field field = new Field("Frame", DataType.NUMERIC);
                            cont.getReport().addField((AbstractField)field);
                            cont.getReport().setValue((AbstractField)field, (Object)event.getStreamIndex());
                            field = new Field("Timestamp", DataType.STRING);
                            DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
                            cont.getReport().addField((AbstractField)field);
                            cont.getReport().setValue((AbstractField)field, (Object)dformat.format(new Date(event.getTimeStamp(TimeUnit.MILLISECONDS))));
                            MovieImageSequence.this.m_OutputToken = new Token((Object)cont);
                            MovieImageSequence.this.m_LastPtsWrite += MovieImageSequence.this.m_MicroSecondsBetweenFrames;
                        }
                    }
                    catch (Exception e) {
                        MovieImageSequence.this.handleException("Failed to process video event!", e);
                    }
                }
            };
            this.m_Reader.addListener((IMediaListener)this.m_Listener);
            IError error = this.m_Reader.readPacket();
            if (error != null) {
                result = "Failed to start reading: " + error.toString();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to open video file: " + payload, e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Reader != null && this.m_Reader.isOpen();
    }

    public Token output() {
        Token result = null;
        while (this.m_Reader.readPacket() == null && this.m_OutputToken == null) {
        }
        if (this.m_OutputToken != null) {
            result = this.m_OutputToken;
            this.m_OutputToken = null;
        } else {
            this.m_Reader.removeListener((IMediaListener)this.m_Listener);
            this.m_Reader = null;
            this.m_Listener = null;
        }
        if (result != null) {
            this.updateProvenance((ProvenanceContainer)result);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        if (this.m_Reader != null) {
            this.m_Reader.removeListener((IMediaListener)this.m_Listener);
            if (this.m_Reader.isOpen()) {
                this.m_Reader.close();
            }
            this.m_Reader = null;
        }
        super.wrapUp();
    }
}

