/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.core.base.QuadrilateralLocation;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.objecttracker.AbstractSimpleReportBasedObjectTracker;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.struct.image.ImageBase;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBoofCVObjectTracker
extends AbstractSimpleReportBasedObjectTracker {
    private static final long serialVersionUID = -8364076045858032972L;
    protected BoofCVImageType m_ImageType;
    protected TrackerObjectQuad m_Tracker;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)BoofCVImageType.UNSIGNED_INT_8);
    }

    public void setImageType(BoofCVImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public BoofCVImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The image type to use.";
    }

    protected abstract TrackerObjectQuad newTracker();

    @Override
    protected String doInitTracking(AbstractImageContainer cont, List<QuadrilateralLocation> locations) {
        BoofCVImageContainer bcont = BoofCVHelper.toBoofCVImageContainer((AbstractImageContainer)cont, (BoofCVImageType)this.m_ImageType);
        ImageBase frame = (ImageBase)bcont.getImage();
        this.m_Tracker = this.newTracker();
        if (!this.m_Tracker.initialize(frame, locations.get(0).quadrilateralValue())) {
            return "Failed to initialze tracker!";
        }
        return null;
    }

    @Override
    protected List<QuadrilateralLocation> doTrackObjects(AbstractImageContainer cont) {
        BoofCVImageContainer bcont = BoofCVHelper.toBoofCVImageContainer((AbstractImageContainer)cont, (BoofCVImageType)this.m_ImageType);
        ImageBase frame = (ImageBase)bcont.getImage();
        Quadrilateral_F64 location = ((QuadrilateralLocation)this.m_LastLocations.get(0)).quadrilateralValue();
        boolean visible = this.m_Tracker.process(frame, location);
        this.m_LastLocations = new ArrayList();
        this.m_LastLocations.add(new QuadrilateralLocation(location));
        if (this.isLoggingEnabled()) {
            this.getLogger().info("visible=" + visible);
        }
        return this.m_LastLocations;
    }
}

