/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.flow.transformer.objecttracker.AbstractBoofCVObjectTracker;
import boofcv.abst.tracker.MeanShiftLikelihoodType;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class BoofCVMeanShiftLikelihood
extends AbstractBoofCVObjectTracker {
    private static final long serialVersionUID = 7061565466109634695L;
    protected MeanShiftLikelihoodType m_Type;
    protected int m_MaxIterations;
    protected int m_NumBins;
    protected int m_MaxPixelValue;
    protected int m_NumBands;

    public String globalInfo() {
        return "Very basic and very fast implementation of mean-shift which uses a fixed sized rectangle for its region. Works best when the target is composed of a single color.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)MeanShiftLikelihoodType.HISTOGRAM);
        this.m_OptionManager.add("max-iterations", "maxIterations", (Object)30, (Number)1, null);
        this.m_OptionManager.add("num-bins", "numBins", (Object)5, (Number)1, null);
        this.m_OptionManager.add("max-pixel-value", "maxPixelValue", (Object)255, (Number)1, null);
        this.m_OptionManager.add("num-bands", "numBands", (Object)3, (Number)1, null);
    }

    public void setType(MeanShiftLikelihoodType value) {
        this.m_Type = value;
        this.reset();
    }

    public MeanShiftLikelihoodType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The likelihood type to use.";
    }

    public void setMaxIterations(int value) {
        this.m_MaxIterations = value;
        this.reset();
    }

    public int getMaxIterations() {
        return this.m_MaxIterations;
    }

    public String maxIterationsTipText() {
        return "The maximum number of iterations to perform.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use for the histogram.";
    }

    public void setMaxPixelValue(int value) {
        this.m_MaxPixelValue = value;
        this.reset();
    }

    public int getMaxPixelValue() {
        return this.m_MaxPixelValue;
    }

    public String maxPixelValueTipText() {
        return "The maximum value of the pixel values (usually 255, since using bytes).";
    }

    public void setNumBands(int value) {
        this.m_NumBands = value;
        this.reset();
    }

    public int getNumBands() {
        return this.m_NumBands;
    }

    public String numBandsTipText() {
        return "The number of bands in the image (= 3 for RGB).";
    }

    @Override
    protected TrackerObjectQuad newTracker() {
        switch (this.m_ImageType) {
            case FLOAT_32: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageFloat32.class));
            }
            case FLOAT_64: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageFloat64.class));
            }
            case SIGNED_INT_16: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageSInt16.class));
            }
            case SIGNED_INT_32: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageSInt32.class));
            }
            case SIGNED_INT_64: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageSInt64.class));
            }
            case SIGNED_INT_8: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageSInt8.class));
            }
            case UNSIGNED_INT_16: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageUInt16.class));
            }
            case UNSIGNED_INT_8: {
                return FactoryTrackerObjectQuad.meanShiftLikelihood((int)this.m_MaxIterations, (int)this.m_NumBins, (double)this.m_MaxPixelValue, (MeanShiftLikelihoodType)this.m_Type, (ImageType)ImageType.ms((int)this.m_NumBands, ImageUInt8.class));
            }
        }
        throw new IllegalStateException("Unhandled image type: " + this.m_ImageType);
    }
}

