/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.Properties;
import adams.data.container.DataPoint;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import adams.gui.action.AbstractBaseAction;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.dialog.EditBindingsDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.visualization.annotator.Binding;
import adams.gui.visualization.video.vlcjplayer.VLCjPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AnnotatorPanel
extends BasePanel
implements MenuBarProvider,
CleanUpHandler {
    public static final String SESSION_FILE = "AnnotatorSession.props";
    private static final long serialVersionUID = 6965340882268141821L;
    private List<Binding> m_Bindings;
    private TitleGenerator m_TitleGenerator;
    private VLCjPanel m_VideoPlayer;
    private BasePanel m_BindingPanel;
    private EditBindingsDialog m_BindingsDialog;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected JMenu m_MenuFileLoadRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected AbstractBaseAction m_ActionMute;
    protected AbstractBaseAction m_ActionPlay;
    protected AbstractBaseAction m_ActionPause;
    protected AbstractBaseAction m_ActionStop;
    protected AbstractBaseAction m_ActionEditBindings;
    protected AbstractBaseAction m_ActionExportTrail;
    protected AbstractBaseAction m_ActionSaveBindings;
    protected AbstractBaseAction m_ActionLoadBindings;
    protected DateFormat m_dateFormatter;
    protected JMenuItem m_MenuItemVideoPlay;
    protected JMenuItem m_MenuItemVideoStop;
    protected Trail m_Trail;
    protected SpreadSheetFileChooser m_ExportFileChooser;
    protected BaseFileChooser m_SavePropertiesFileChooser;
    protected BaseFileChooser m_LoadPropertiesFileChooser;

    protected void initialize() {
        super.initialize();
        this.m_TitleGenerator = new TitleGenerator("Annotator", true);
        this.m_dateFormatter = new DateFormat("HH:mm:ss");
        this.m_Bindings = new ArrayList<Binding>();
        this.m_ExportFileChooser = new SpreadSheetFileChooser();
        this.m_SavePropertiesFileChooser = new BaseFileChooser();
        this.m_LoadPropertiesFileChooser = new BaseFileChooser();
        this.initActions();
    }

    protected void initActions() {
        AbstractBaseAction action = new AbstractBaseAction("Mute", "mute.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.m_VideoPlayer.mute();
            }
        };
        action.setMnemonic(77);
        action.setAccelerator("ctrl pressed M");
        this.m_ActionMute = action;
        action = new AbstractBaseAction("Play", "run.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.m_VideoPlayer.play();
            }
        };
        action.setMnemonic(80);
        action.setAccelerator("ctrl pressed P");
        this.m_ActionPlay = action;
        action = new AbstractBaseAction("Pause", "pause.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.m_VideoPlayer.pause();
            }
        };
        action.setMnemonic(85);
        action.setAccelerator("ctrl pressed U");
        this.m_ActionPause = action;
        action = new AbstractBaseAction("Stop", "stop_blue.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.m_VideoPlayer.stop();
                System.out.println((Object)AnnotatorPanel.this.m_Trail);
            }
        };
        action.setMnemonic(83);
        action.setAccelerator("ctrl pressed S");
        this.m_ActionStop = action;
        this.m_ActionEditBindings = action = new AbstractBaseAction("Edit Bindings...", "edit.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.editBindings();
            }
        };
        this.m_ActionExportTrail = action = new AbstractBaseAction("Export...", "spreadsheet.png"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.export();
            }
        };
        this.m_ActionSaveBindings = action = new AbstractBaseAction("Save Bindings...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.saveBindings();
            }
        };
        this.m_ActionLoadBindings = action = new AbstractBaseAction("Load Bindings...", "load.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.loadBindings();
            }
        };
    }

    protected void initGUI() {
        super.initGUI();
        this.m_VideoPlayer = new VLCjPanel();
        this.m_BindingPanel = new BasePanel((LayoutManager)new FlowLayout());
        this.add((Component)((Object)this.m_VideoPlayer), "Center");
        this.add((Component)this.m_BindingPanel, "South");
    }

    protected void finishInit() {
        super.finishInit();
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Open...", GUIHelper.getIcon((String)"open.gif"));
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(e -> {
                if (this.m_VideoPlayer.open()) {
                    this.m_Trail = new Trail();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AnnotatorPanel.this.m_VideoPlayer.open((File)e.getItem());
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menu.addSeparator();
            menuitem = new JMenuItem((Action)this.m_ActionLoadBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionSaveBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionExportTrail);
            menu.addSeparator();
            menu.add(menuitem);
            menuitem = new JMenuItem("Close", GUIHelper.getIcon((String)"exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.addActionListener(e -> this.close());
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            menu.add(menuitem);
            menu = new JMenu("Video");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionPlay);
            menuitem.setEnabled(false);
            this.m_MenuItemVideoPlay = menuitem;
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionStop);
            menuitem.setEnabled(false);
            this.m_MenuItemVideoStop = menuitem;
            menu.add(menuitem);
            menu = new JMenu("Bindings");
            result.add(menu);
            menu.setMnemonic('B');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionEditBindings);
            menu.add(menuitem);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        Runnable run = () -> {
            String title = this.m_TitleGenerator.generate(this.m_VideoPlayer.getCurrentFile());
            this.setParentTitle(title);
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        Runnable run = () -> {
            this.m_MenuItemVideoPlay.setEnabled(this.m_VideoPlayer.isVideoLoaded());
            this.m_MenuItemVideoStop.setEnabled(this.m_VideoPlayer.isVideoPlaying());
            if (this.m_VideoPlayer.isVideoPlaying() && !this.m_VideoPlayer.isVideoPaused()) {
                this.m_MenuItemVideoPlay.setAction((Action)this.m_ActionPause);
            } else {
                this.m_MenuItemVideoPlay.setAction((Action)this.m_ActionPlay);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void cleanUp() {
        if (this.m_BindingsDialog != null) {
            this.m_BindingsDialog.dispose();
            this.m_BindingsDialog = null;
        }
        if (this.m_VideoPlayer != null) {
            this.m_VideoPlayer.cleanUp();
        }
    }

    private void updateBindingBar() {
        System.out.println("Updating the Binding Bar");
        Runnable run = () -> {
            System.out.println("adding a binding label");
            for (Binding item : this.m_Bindings) {
                this.m_BindingPanel.add((Component)new JLabel(item.getName()));
                this.m_BindingPanel.revalidate();
                this.addKeyBinding(item);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private AbstractBaseAction addKeyBinding(final Binding binding) {
        AbstractBaseAction action = new AbstractBaseAction(){

            protected void doActionPerformed(ActionEvent e) {
                long msec = AnnotatorPanel.this.m_VideoPlayer.getTimeStamp();
                if (msec == -1L) {
                    return;
                }
                HashMap<String, Object> meta = new HashMap<String, Object>();
                meta.put(binding.getName(), !binding.isInverted());
                Date timestamp = new Date(msec);
                Step step = new Step(timestamp, 0.0f, 0.0f, meta);
                Step oldStep = AnnotatorPanel.this.m_Trail.getStep(timestamp);
                if (oldStep != null && oldStep.hasMetaData()) {
                    step.getMetaData().putAll(oldStep.getMetaData());
                }
                AnnotatorPanel.this.m_Trail.add((DataPoint)step);
                System.out.println(binding.getName() + " " + AnnotatorPanel.this.m_dateFormatter.format(new Date(AnnotatorPanel.this.m_VideoPlayer.getTimeStamp())));
            }
        };
        KeyStroke keyStroke = binding.getBinding();
        System.out.println("key " + keyStroke + " name " + binding.getName());
        this.getInputMap(2).put(keyStroke, binding.getName());
        this.getActionMap().put(binding.getName(), (Action)action);
        return action;
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
    }

    protected void close() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
        this.cleanUp();
        this.closeParent();
    }

    public void editBindings() {
        this.m_BindingsDialog = this.getParentDialog() != null ? new EditBindingsDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new EditBindingsDialog(this.getParentFrame(), true);
        this.m_BindingsDialog.setBindings(this.m_Bindings);
        this.m_BindingsDialog.setLocationRelativeTo((Component)((Object)this));
        this.m_BindingsDialog.setVisible(true);
        this.m_Bindings = this.m_BindingsDialog.getBindings();
        this.updateBindingBar();
    }

    public void export() {
        if (this.m_Trail == null) {
            return;
        }
        int retVal = this.m_ExportFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        SpreadSheet sheet = this.m_Trail.toSpreadSheet();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_ExportFileChooser.getWriter();
        if (!writer.write(sheet, this.m_ExportFileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to export data to: " + this.m_ExportFileChooser.getSelectedFile()));
        }
    }

    public void loadBindings() {
        Properties props = new Properties();
        int retVal = this.m_LoadPropertiesFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        props.load(this.m_LoadPropertiesFileChooser.getSelectedFile().getAbsolutePath());
        int count = props.getInteger("Count");
        for (int i = 0; i < count; ++i) {
            this.m_Bindings.add(new Binding(props.getProperty(i + ".Name"), props.getProperty(i + ".Binding"), (boolean)props.getBoolean(i + ".Toggleable"), (boolean)props.getBoolean(i + ".Inverted")));
        }
        this.updateBindingBar();
    }

    public void saveBindings() {
        int i;
        Properties props = new Properties();
        int retVal = this.m_SavePropertiesFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (i = 0; i < this.m_Bindings.size(); ++i) {
            props.add(this.m_Bindings.get(i).toProperty(i));
        }
        props.setInteger("Count", Integer.valueOf(i));
        props.save(this.m_SavePropertiesFileChooser.getSelectedFile().getAbsolutePath());
    }
}

