/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.gui.action.AbstractBaseAction;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.BasePanel;
import adams.gui.dialog.EditBindingDialog;
import adams.gui.visualization.annotator.Binding;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;

public class BindingsEditorPanel
extends BasePanel {
    protected BaseListWithButtons m_BindingsList;
    protected JButton m_AddButton;
    protected JButton m_DeleteButton;
    protected JButton m_EditButton;
    protected EditBindingDialog m_EditDialog;
    protected AbstractBaseAction m_AddAction;
    protected AbstractBaseAction m_DeleteAction;
    protected AbstractBaseAction m_EditAction;
    protected DefaultListModel<Binding> m_Model;

    protected void initActions() {
        this.m_AddAction = new AbstractBaseAction("Add", "add.gif"){

            protected void doActionPerformed(ActionEvent e) {
                if (BindingsEditorPanel.this.m_EditDialog == null) {
                    if (BindingsEditorPanel.this.getParentDialog() != null) {
                        BindingsEditorPanel.this.m_EditDialog = new EditBindingDialog(BindingsEditorPanel.this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL);
                        BindingsEditorPanel.this.m_EditDialog.setSize(200, 200);
                    } else {
                        BindingsEditorPanel.this.m_EditDialog = new EditBindingDialog(BindingsEditorPanel.this.getParentFrame(), true);
                    }
                } else {
                    BindingsEditorPanel.this.m_EditDialog.clearFields();
                }
                BindingsEditorPanel.this.m_EditDialog.setLocationRelativeTo((Component)((Object)BindingsEditorPanel.this));
                BindingsEditorPanel.this.m_EditDialog.setVisible(true);
                BindingsEditorPanel.this.m_Model.addElement(BindingsEditorPanel.this.m_EditDialog.getBinding());
            }
        };
        this.m_EditAction = new AbstractBaseAction("Edit", "edit.gif"){

            protected void doActionPerformed(ActionEvent e) {
            }
        };
        this.m_DeleteAction = new AbstractBaseAction("Remove", "remove.gif"){

            protected void doActionPerformed(ActionEvent e) {
                int[] indices = BindingsEditorPanel.this.m_BindingsList.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    BindingsEditorPanel.this.m_Model.remove(indices[i]);
                }
            }
        };
    }

    protected void initialize() {
        super.initialize();
        this.initActions();
    }

    protected void initGUI() {
        super.initGUI();
        this.m_Model = new DefaultListModel();
        this.m_BindingsList = new BaseListWithButtons(this.m_Model);
        this.setLayout(new GridLayout(1, 2));
        this.m_AddButton = new JButton((Action)this.m_AddAction);
        this.m_BindingsList.addToButtonsPanel((Component)this.m_AddButton);
        this.m_DeleteButton = new JButton((Action)this.m_DeleteAction);
        this.m_BindingsList.addToButtonsPanel((Component)this.m_DeleteButton);
        this.m_EditButton = new JButton((Action)this.m_EditAction);
        this.m_EditButton.setEnabled(false);
        this.m_BindingsList.addToButtonsPanel((Component)this.m_EditButton);
        this.add((Component)this.m_BindingsList);
    }

    public List<Binding> getBindings() {
        ArrayList<Binding> result = new ArrayList<Binding>();
        for (int i = 0; i < this.m_Model.size(); ++i) {
            result.add(this.m_Model.get(i));
        }
        return result;
    }

    public void setBindings(List<Binding> bindings) {
        this.m_Model.clear();
        for (Binding binding : bindings) {
            this.m_Model.addElement(binding);
        }
    }
}

