/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.trail.Trail;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class NewTrail
extends AbstractSimpleSource {
    private static final long serialVersionUID = -5718059337341470131L;
    protected String m_ID;
    protected float m_Width;
    protected float m_Height;

    public String globalInfo() {
        return "Generates an empty trail with the specified dimensions.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)"");
        this.m_OptionManager.add("width", "width", (Object)Float.valueOf(this.getDefaultWidth()), (Number)Float.valueOf(1.0f), null);
        this.m_OptionManager.add("height", "height", (Object)Float.valueOf(this.getDefaultHeight()), (Number)Float.valueOf(1.0f), null);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"ID", (Object)(this.m_ID.isEmpty() ? "-none-" : this.m_ID), (String)"ID: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)Float.valueOf(this.m_Width), (String)", ");
        result = result + " x ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)Float.valueOf(this.m_Height));
        return result;
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID of the trail; ignored if empty.";
    }

    public float getDefaultWidth() {
        return 800.0f;
    }

    public void setWidth(float value) {
        if (this.getOptionManager().isValid("width", (Number)Float.valueOf(value))) {
            this.m_Width = value;
            this.reset();
        }
    }

    public float getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the trail.";
    }

    public float getDefaultHeight() {
        return 600.0f;
    }

    public void setHeight(float value) {
        if (this.getOptionManager().isValid("height", (Number)Float.valueOf(value))) {
            this.m_Height = value;
            this.reset();
        }
    }

    public float getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the trail.";
    }

    public Class[] generates() {
        return new Class[]{Trail.class};
    }

    protected String doExecute() {
        Trail trail = new Trail();
        if (!this.m_ID.isEmpty()) {
            trail.setID(this.m_ID);
        }
        trail.setWidth(Float.valueOf(this.m_Width));
        trail.setHeight(Float.valueOf(this.m_Height));
        this.m_OutputToken = new Token((Object)trail);
        return null;
    }
}

