/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.core.QuickInfoSupporter;
import adams.core.base.QuadrilateralLocation;
import adams.core.option.AbstractOptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.objecttracker.ObjectTracker;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractObjectTracker
extends AbstractOptionHandler
implements ObjectTracker,
QuickInfoSupporter {
    private static final long serialVersionUID = -7912135967034523506L;
    protected boolean m_Initialized;
    protected List<QuadrilateralLocation> m_LastLocations;

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
        this.m_LastLocations = new ArrayList<QuadrilateralLocation>();
    }

    public String getQuickInfo() {
        return null;
    }

    protected abstract List<QuadrilateralLocation> getInitialLocations(AbstractImageContainer var1);

    protected String checkInitTracking(AbstractImageContainer cont, List<QuadrilateralLocation> locations) {
        if (cont == null) {
            return "No image provided for tracking initialization!";
        }
        if (locations == null || locations.size() == 0) {
            return "No initial object locations available!";
        }
        return null;
    }

    protected abstract String doInitTracking(AbstractImageContainer var1, List<QuadrilateralLocation> var2);

    @Override
    public String initTracking(AbstractImageContainer cont) {
        this.m_LastLocations.clear();
        List<QuadrilateralLocation> locations = this.getInitialLocations(cont);
        String result = this.checkInitTracking(cont, locations);
        if (result == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Initializing with location=" + locations);
            }
            result = this.doInitTracking(cont, locations);
        }
        boolean bl = this.m_Initialized = result == null;
        if (!this.m_Initialized) {
            this.m_LastLocations.clear();
        } else {
            this.m_LastLocations.clear();
            this.m_LastLocations.addAll(locations);
        }
        if (result != null) {
            this.getLogger().severe(result);
        }
        return result;
    }

    @Override
    public boolean isInitialized() {
        return this.m_Initialized;
    }

    protected String checkTrackObjects(AbstractImageContainer cont) {
        if (cont == null) {
            return "No image provided for tracking!";
        }
        return null;
    }

    protected abstract List<QuadrilateralLocation> doTrackObjects(AbstractImageContainer var1);

    protected List<QuadrilateralLocation> postProcessTrackedObjects(AbstractImageContainer cont, List<QuadrilateralLocation> locations) {
        return locations;
    }

    @Override
    public List<QuadrilateralLocation> trackObjects(AbstractImageContainer cont) {
        String msg = this.checkTrackObjects(cont);
        if (msg != null) {
            this.getLogger().severe(msg);
            return null;
        }
        List<QuadrilateralLocation> result = this.doTrackObjects(cont);
        if (result != null) {
            result = this.postProcessTrackedObjects(cont, result);
            this.m_LastLocations = result;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Tracked locations=" + result);
        }
        return result;
    }
}

