/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.flow.transformer.objecttracker.AbstractBoofCVObjectTracker;
import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class BoofCVCirculant
extends AbstractBoofCVObjectTracker {
    private static final long serialVersionUID = 7061565466109634695L;
    protected double m_OutputSigmaFactor;
    protected double m_Sigma;
    protected double m_Lambda;
    protected double m_InterpFactor;
    protected double m_MaxPixelValue;
    protected double m_Padding;
    protected int m_WorkSpace;

    public String globalInfo() {
        return "Creates the Circulant feature tracker. Texture based tracker which uses the theory of circulant matrices, Discrete Fourier Transform (DCF), and linear classifiers to track a target. Fixed sized rectangular target and only estimates translation. Can't detect when it loses track or re-aquire track.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-sigma-factor", "outputSigmaFactor", (Object)0.0625);
        this.m_OptionManager.add("sigma", "sigma", (Object)0.2);
        this.m_OptionManager.add("lambda", "lambda", (Object)0.01);
        this.m_OptionManager.add("interp-factor", "interpFactor", (Object)0.075);
        this.m_OptionManager.add("max-pixel-value", "maxPixelValue", (Object)255.0);
        this.m_OptionManager.add("padding", "padding", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("work-space", "workSpace", (Object)64, (Number)1, null);
    }

    public void setOutputSigmaFactor(double value) {
        if (this.getOptionManager().isValid("outputSigmaFactor", (Number)value)) {
            this.m_OutputSigmaFactor = value;
            this.reset();
        }
    }

    public double getOutputSigmaFactor() {
        return this.m_OutputSigmaFactor;
    }

    public String outputSigmaFactorTipText() {
        return "The spatial bandwidth. Proportional to target size.";
    }

    public void setSigma(double value) {
        if (this.getOptionManager().isValid("sigma", (Number)value)) {
            this.m_Sigma = value;
            this.reset();
        }
    }

    public double getSigma() {
        return this.m_Sigma;
    }

    public String sigmaTipText() {
        return "The gaussian kernel bandwidth.";
    }

    public void setLambda(double value) {
        if (this.getOptionManager().isValid("lambda", (Number)value)) {
            this.m_Lambda = value;
            this.reset();
        }
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The regularization term.";
    }

    public void setInterpFactor(double value) {
        if (this.getOptionManager().isValid("interpFactor", (Number)value)) {
            this.m_InterpFactor = value;
            this.reset();
        }
    }

    public double getInterpFactor() {
        return this.m_InterpFactor;
    }

    public String interpFactorTipText() {
        return "The weighting factor mixing old track image and new one. Effectively adjusts the rate at which it can adjust to changes in appearance. Values closer to zero slow down the rate of change. 0.0 is no update. 0.075 is recommended.";
    }

    public void setMaxPixelValue(double value) {
        if (this.getOptionManager().isValid("maxPixelValue", (Number)value)) {
            this.m_MaxPixelValue = value;
            this.reset();
        }
    }

    public double getMaxPixelValue() {
        return this.m_MaxPixelValue;
    }

    public String maxPixelValueTipText() {
        return "The maximum pixel value. Used to normalize image. 8-bit images are 255.";
    }

    public void setPadding(double value) {
        if (this.getOptionManager().isValid("padding", (Number)value)) {
            this.m_Padding = value;
            this.reset();
        }
    }

    public double getPadding() {
        return this.m_Padding;
    }

    public String paddingTipText() {
        return "How much padding is added around the region requested by the user. Specified as fraction of original image. Padding of 1 = 2x original size.";
    }

    public void setWorkSpace(int value) {
        if (this.getOptionManager().isValid("workSpace", (Number)value)) {
            this.m_WorkSpace = value;
            this.reset();
        }
    }

    public int getWorkSpace() {
        return this.m_WorkSpace;
    }

    public String workSpaceTipText() {
        return "The length of size in work space image. A total of N*N points are sampled. Should be set to a power of two to maximize speed. In general, larger numbers are more stable but slower.";
    }

    @Override
    protected TrackerObjectQuad newTracker() {
        ConfigCirculantTracker config = new ConfigCirculantTracker();
        config.output_sigma_factor = this.m_OutputSigmaFactor;
        config.sigma = this.m_Sigma;
        config.lambda = this.m_Lambda;
        config.interp_factor = this.m_InterpFactor;
        config.maxPixelValue = this.m_MaxPixelValue;
        config.padding = this.m_Padding;
        config.workSpace = this.m_WorkSpace;
        switch (this.m_ImageType) {
            case FLOAT_32: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageFloat32.class);
            }
            case FLOAT_64: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageFloat64.class);
            }
            case SIGNED_INT_16: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageSInt16.class);
            }
            case SIGNED_INT_32: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageSInt32.class);
            }
            case SIGNED_INT_64: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageSInt64.class);
            }
            case SIGNED_INT_8: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageSInt8.class);
            }
            case UNSIGNED_INT_16: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageUInt16.class);
            }
            case UNSIGNED_INT_8: {
                return FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, ImageUInt8.class);
            }
        }
        throw new IllegalStateException("Unhandled image type: " + this.m_ImageType);
    }
}

