/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.data.trail.Step;
import adams.gui.action.AbstractBaseAction;
import adams.gui.core.BasePanel;
import adams.gui.visualization.annotator.AnnotationEvent;
import adams.gui.visualization.annotator.AnnotationListener;
import adams.gui.visualization.annotator.Binding;
import adams.gui.visualization.annotator.TickEvent;
import adams.gui.visualization.annotator.TickListener;
import adams.gui.visualization.video.vlcjplayer.VLCjDirectRenderPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AnnotationPanel
extends BasePanel
implements TickListener {
    private static final long serialVersionUID = -8145795884307782157L;
    public static final int BORDER_THICKNESS = 5;
    public static final Color OFF_COLOUR = Color.RED;
    public static final Color ON_COLOUR = Color.GREEN;
    protected List<AnnotationListener> m_Listeners;
    protected Binding m_Binding;
    protected VLCjDirectRenderPanel m_VideoPlayer;
    protected AbstractBaseAction m_Action;
    protected long m_Interval;
    protected boolean m_IsToggleable;
    protected boolean m_IsToggled;
    protected JButton m_Button;

    public void configureAnnotationPanel(Binding binding, VLCjDirectRenderPanel videoPlayer) {
        this.m_Binding = binding;
        this.m_VideoPlayer = videoPlayer;
        this.m_Interval = binding.getInterval();
        this.m_IsToggleable = binding.isToggleable();
        this.addKeyBinding(this.m_Binding);
    }

    protected void makeStep(Date timestamp) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (this.m_IsToggleable) {
            meta.put(this.m_Binding.getName(), this.m_Binding.isInverted() ^ this.m_IsToggled);
        } else {
            meta.put(this.m_Binding.getName(), !this.m_Binding.isInverted());
        }
        Step step = new Step(timestamp, 0.0f, 0.0f, meta);
        this.notifyListeners(step);
    }

    protected void initialize() {
        super.initialize();
        this.m_IsToggled = false;
        this.m_Listeners = new ArrayList<AnnotationListener>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new FlowLayout(1));
        this.m_Button = new JButton();
        this.add(this.m_Button);
    }

    protected void finishInit() {
        super.finishInit();
    }

    public void addListener(AnnotationListener listener) {
        if (this.m_Listeners.contains(listener)) {
            return;
        }
        this.m_Listeners.add(listener);
    }

    protected AbstractBaseAction addKeyBinding(Binding binding) {
        KeyStroke keyStroke = binding.getBinding();
        if (this.m_IsToggleable) {
            this.setBorder(new LineBorder(OFF_COLOUR, 5));
            this.m_Action = new AbstractBaseAction(binding.getName() + " (" + binding.getBinding() + ")"){

                protected void doActionPerformed(ActionEvent e) {
                    boolean bl = AnnotationPanel.this.m_IsToggled = !AnnotationPanel.this.m_IsToggled;
                    if (AnnotationPanel.this.m_IsToggled) {
                        Runnable run = () -> {
                            AnnotationPanel.this.setBorder(new LineBorder(ON_COLOUR, 5));
                            AnnotationPanel.this.revalidate();
                        };
                        SwingUtilities.invokeLater(run);
                    } else {
                        Runnable run = () -> {
                            AnnotationPanel.this.setBorder(new LineBorder(OFF_COLOUR, 5));
                            AnnotationPanel.this.revalidate();
                        };
                        SwingUtilities.invokeLater(run);
                    }
                }
            };
        } else {
            this.setBorder(new LineBorder(this.getBackground(), 5));
            this.m_Action = new AbstractBaseAction(binding.getName() + " (" + binding.getBinding() + ")"){

                protected void doActionPerformed(ActionEvent e) {
                    Date timestamp = new Date(AnnotationPanel.this.m_VideoPlayer.getTimeStamp());
                    AnnotationPanel.this.makeStep(timestamp);
                }
            };
        }
        this.m_Button.setAction((Action)this.m_Action);
        this.getInputMap(2).put(keyStroke, binding.getName());
        this.getActionMap().put(binding.getName(), (Action)this.m_Action);
        return this.m_Action;
    }

    protected void notifyListeners(Step step) {
        if (this.m_Listeners == null) {
            return;
        }
        AnnotationEvent e = new AnnotationEvent(this, step);
        for (AnnotationListener listener : this.m_Listeners) {
            listener.annotationOccurred(e);
        }
    }

    @Override
    public void tickHappened(TickEvent e) {
        this.makeStep(e.getTimeStamp());
    }

    @Override
    public long getInterval() {
        return this.m_Interval;
    }
}

