/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.movieimagesampler;

import adams.core.base.BaseTimeMsec;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.transformer.movieimagesampler.AbstractBufferedImageMovieImageSampler;
import adams.gui.visualization.video.vlcjplayer.VideoUtilities;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.condition.conditions.PausedCondition;
import uk.co.caprica.vlcj.player.condition.conditions.PlayingCondition;
import uk.co.caprica.vlcj.player.condition.conditions.TimeReachedCondition;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.direct.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;

public class SingleTimestampMovieSampler
extends AbstractBufferedImageMovieImageSampler {
    protected long m_TimeStampLong;
    protected BaseTimeMsec m_Timestamp;
    protected DirectMediaPlayer m_MediaPlayer;
    protected long m_TargetTime;
    protected List<BufferedImageContainer> m_Samples;
    protected MediaPlayerFactory m_Factory;
    protected Dimension m_VideoDimension;
    protected BufferedImage m_Image;
    protected BufferedImageContainer m_CurrentImage;
    protected BufferedImageContainer m_PreviousImage;
    protected long m_TimeOffset;
    protected File m_File;

    protected void reset() {
        super.reset();
        this.m_TimeStampLong = -1L;
    }

    public void setTimeStamp(BaseTimeMsec timeStamp) {
        this.m_Timestamp = timeStamp;
        this.reset();
    }

    public BaseTimeMsec getTimeStamp() {
        return this.m_Timestamp;
    }

    public void setTimeStampAsLong(long timeStamps) {
        this.m_TimeStampLong = timeStamps;
    }

    public long getTimeStampAsLong() {
        this.m_TimeOffset = new BaseTimeMsec("00:00:00.000").dateValue().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_Timestamp.dateValue());
        long hours = calendar.get(11);
        long minutes = calendar.get(12);
        long seconds = calendar.get(13);
        long mseconds = calendar.get(14);
        this.m_TimeStampLong += hours * 3600000L;
        this.m_TimeStampLong += minutes * 60000L;
        this.m_TimeStampLong += seconds * 1000L;
        this.m_TimeStampLong += mseconds;
        return this.m_TimeStampLong;
    }

    public String timeStampTipText() {
        return "The timestamp to capture the image at.";
    }

    public String globalInfo() {
        return "Generates an image at each of the provided timestamps";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp", "timeStamp", (Object)new BaseTimeMsec[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImage = new BufferedImageContainer();
        this.m_PreviousImage = new BufferedImageContainer();
    }

    protected BufferedImageContainer[] doSample(final File file) {
        long timestamp = this.getTimeStampAsLong();
        boolean first = false;
        if (this.m_File == null) {
            this.m_File = file;
            this.m_VideoDimension = VideoUtilities.getVideoDimensions(file.getAbsolutePath());
            this.m_Image = new BufferedImage((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight(), 1);
            this.m_Factory = new MediaPlayerFactory();
            BufferFormatCallback bufferFormatCallback = (i, i1) -> new RV32BufferFormat((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight());
            this.m_MediaPlayer = this.m_Factory.newDirectMediaPlayer(bufferFormatCallback, (RenderCallback)new SnapshotRenderCallback());
            first = true;
        }
        this.m_Samples = new ArrayList<BufferedImageContainer>();
        try {
            PlayingCondition playingCondition = new PlayingCondition((MediaPlayer)this.m_MediaPlayer){

                protected boolean onBefore() {
                    if (!SingleTimestampMovieSampler.this.m_MediaPlayer.isPlayable()) {
                        return SingleTimestampMovieSampler.this.m_MediaPlayer.startMedia(file.getAbsolutePath(), new String[0]);
                    }
                    SingleTimestampMovieSampler.this.m_MediaPlayer.play();
                    return true;
                }
            };
            playingCondition.await();
            System.out.println("Ding " + timestamp);
            this.m_TargetTime = timestamp;
            if (this.m_TargetTime > this.m_MediaPlayer.getLength()) {
                return null;
            }
            TimeReachedCondition timeReachedCondition = new TimeReachedCondition((MediaPlayer)this.m_MediaPlayer, this.m_TargetTime){

                protected boolean onBefore() {
                    SingleTimestampMovieSampler.this.m_MediaPlayer.setTime(this.targetTime);
                    return true;
                }
            };
            timeReachedCondition.await();
            PausedCondition pausedCondition = new PausedCondition((MediaPlayer)this.m_MediaPlayer){

                protected boolean onBefore() {
                    SingleTimestampMovieSampler.this.m_MediaPlayer.pause();
                    return true;
                }
            };
            pausedCondition.await();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return this.m_Samples.toArray(new BufferedImageContainer[this.m_Samples.size()]);
    }

    public void cleanUp() {
        this.m_MediaPlayer.release();
        this.m_Factory.release();
    }

    private class SnapshotRenderCallback
    extends RenderCallbackAdapter {
        SnapshotRenderCallback() {
            super(new int[(int)SingleTimestampMovieSampler.this.m_VideoDimension.getWidth() * (int)SingleTimestampMovieSampler.this.m_VideoDimension.getHeight()]);
        }

        protected void onDisplay(DirectMediaPlayer directMediaPlayer, int[] rgbBuffer) {
            SingleTimestampMovieSampler.this.m_Image = new BufferedImage((int)SingleTimestampMovieSampler.this.m_VideoDimension.getWidth(), (int)SingleTimestampMovieSampler.this.m_VideoDimension.getHeight(), 1);
            SingleTimestampMovieSampler.this.m_CurrentImage = new BufferedImageContainer();
            SingleTimestampMovieSampler.this.m_Image.setRGB(0, 0, (int)SingleTimestampMovieSampler.this.m_VideoDimension.getWidth(), (int)SingleTimestampMovieSampler.this.m_VideoDimension.getHeight(), rgbBuffer, 0, (int)SingleTimestampMovieSampler.this.m_VideoDimension.getWidth());
            SingleTimestampMovieSampler.this.m_CurrentImage.setImage((Object)SingleTimestampMovieSampler.this.m_Image);
            long currentTime = directMediaPlayer.getTime();
            String ts = new BaseTimeMsec(new Date(currentTime)).getValue();
            if (ts.equals("-INF")) {
                ts = "00:00:00.000";
            }
            SingleTimestampMovieSampler.this.m_CurrentImage.getReport().setValue((AbstractField)new Field("Timestamp", DataType.STRING), (Object)ts);
            if (currentTime == SingleTimestampMovieSampler.this.m_TargetTime) {
                SingleTimestampMovieSampler.this.m_Samples.add(SingleTimestampMovieSampler.this.m_CurrentImage);
                System.out.println("CurrentTime: " + currentTime + " Target Time: " + SingleTimestampMovieSampler.this.m_TargetTime);
            } else {
                System.out.println("CurrentTime: " + currentTime + " Target Time: " + SingleTimestampMovieSampler.this.m_TargetTime);
            }
        }
    }
}

