/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseRegExp;
import adams.core.base.QuadrilateralLocation;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class QuadrilateralLocationsOverlayFromReport
extends AbstractImageOverlay {
    private static final long serialVersionUID = 6356419097401574024L;
    protected BaseRegExp m_RegExp;
    protected Color m_Color;
    protected List<QuadrilateralLocation> m_Locations;

    public String globalInfo() {
        return "Displays the quadrilateral locations of tracked objects in the image, using data from the attached report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp("Tracker\\..*"));
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match against the fields in the report for identifying object locations.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Locations = null;
    }

    protected void determineLocations(Report report) {
        if (this.m_Locations != null) {
            return;
        }
        List fields = report.getFields();
        this.m_Locations = new ArrayList<QuadrilateralLocation>();
        for (AbstractField field : fields) {
            if (!this.m_RegExp.isMatch(field.getName())) continue;
            try {
                QuadrilateralLocation loc = new QuadrilateralLocation(report.getStringValue(field));
                this.m_Locations.add(loc);
            }
            catch (Exception exception) {}
        }
    }

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        this.determineLocations(panel.getOwner().getAdditionalProperties());
        if (this.m_Locations.size() > 0) {
            g.setColor(this.m_Color);
            for (QuadrilateralLocation loc : this.m_Locations) {
                double[] pos = loc.doubleValue();
                int[] x = new int[]{(int)pos[0], (int)pos[2], (int)pos[4], (int)pos[6]};
                int[] y = new int[]{(int)pos[1], (int)pos[3], (int)pos[5], (int)pos[7]};
                g.drawPolygon(x, y, 4);
            }
        }
    }
}

