/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.base.QuadrilateralLocation;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SelectMultipleObjectsToTrack
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    protected Field m_LocationPrefix;

    public String globalInfo() {
        return "Allows the user to select multiple regions (ie objects) to track.\nUses 1-based index as suffix for enumerating locations.\nWhen also holding the CTRL key down, this will delete any encompassed region.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("location-prefix", "locationPrefix", (Object)new Field("Tracker.Init.", DataType.STRING));
    }

    public void setLocationPrefix(Field value) {
        this.m_LocationPrefix = value;
        this.reset();
    }

    public Field getLocationPrefix() {
        return this.m_LocationPrefix;
    }

    public String locationPrefixTipText() {
        return "The prefix for fields to store the location of the objects in (uses 1-based enumeration suffix).";
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        Report report = panel.getAdditionalProperties().getClone();
        ArrayList<AbstractField> current = new ArrayList<AbstractField>();
        int lastIndex = 0;
        for (AbstractField field : report.getFields()) {
            if (!field.getName().startsWith(this.m_LocationPrefix.getName())) continue;
            try {
                int index = Integer.parseInt(field.getName().substring(this.m_LocationPrefix.getName().length()));
                if (index > lastIndex) {
                    lastIndex = index;
                }
                current.add(field);
            }
            catch (Exception exception) {}
        }
        if ((modifiersEx & 0x80) != 0) {
            double scale = panel.getActualScale();
            Rectangle rect = new Rectangle((int)((double)topLeft.x / scale), (int)((double)topLeft.y / scale), (int)((double)bottomRight.x / scale - (double)topLeft.x / scale) + 1, (int)((double)bottomRight.y / scale - (double)topLeft.y / scale) + 1);
            for (AbstractField field : current) {
                QuadrilateralLocation loc = new QuadrilateralLocation(report.getStringValue(field));
                if (!rect.contains(loc.rectangleValue())) continue;
                report.removeValue(field);
            }
        } else {
            ++lastIndex;
            int x1 = panel.mouseToPixelLocation((Point)topLeft).x;
            int y1 = panel.mouseToPixelLocation((Point)topLeft).y;
            int x2 = panel.mouseToPixelLocation((Point)bottomRight).x;
            int y2 = panel.mouseToPixelLocation((Point)bottomRight).y;
            QuadrilateralLocation loc = new QuadrilateralLocation((double)x1, (double)y1, (double)x2, (double)y1, (double)x2, (double)y2, (double)x1, (double)y2);
            Field newField = new Field(this.m_LocationPrefix.getName() + lastIndex, DataType.STRING);
            report.addField((AbstractField)newField);
            report.setValue((AbstractField)newField, (Object)loc.toString());
        }
        panel.setAdditionalProperties(report);
    }
}

