/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractBufferedImageMovieImageSampler.java
 * Copyright (C) 2016 University of Waikato, Hamilton, NZ
 */

package adams.flow.transformer.movieimagesampler;

import adams.data.image.BufferedImageContainer;

/**
 * Ancestor for movie image samples that output {@link BufferedImageContainer}.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision$
 */
public abstract class AbstractBufferedImageMovieImageSampler
  extends AbstractMovieImageSampler<BufferedImageContainer> {

  private static final long serialVersionUID = 6228032107418634609L;

  /**
   * Returns the type of image container the sample generates.
   *
   * @return		the image container class
   */
  @Override
  public Class generates() {
    return BufferedImageContainer.class;
  }
}
