/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.DateUtils;
import adams.core.base.BaseTimeMsec;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import java.util.Date;

public class TrailWindow
extends AbstractFilter<Trail> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected BaseTimeMsec m_Start;
    protected BaseTimeMsec m_End;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Leaves only the specified window in the trail (borders included).\nThe matching can be inverted, i.e., everything but the window is returned.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", (Object)new BaseTimeMsec("-INF"));
        this.m_OptionManager.add("end", "end", (Object)new BaseTimeMsec("+INF"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setStart(BaseTimeMsec value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseTimeMsec getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The timestamp for the first data point in the trail to keep.";
    }

    public void setEnd(BaseTimeMsec value) {
        this.m_End = value;
        this.reset();
    }

    public BaseTimeMsec getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The timestamp for the last data point in the trail to keep.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, everything but the window is kept.";
    }

    protected Trail processData(Trail data) {
        Trail result = (Trail)data.getHeader();
        Date start = this.m_Start.dateValue();
        Date end = this.m_End.dateValue();
        for (int i = 0; i < data.size(); ++i) {
            Step step = (Step)((Object)data.toList().get(i));
            if (this.m_Invert ? !DateUtils.isBefore((Date)start, (Date)step.getTimestamp()) && !DateUtils.isAfter((Date)end, (Date)step.getTimestamp()) : DateUtils.isBefore((Date)start, (Date)step.getTimestamp()) || DateUtils.isAfter((Date)end, (Date)step.getTimestamp())) continue;
            result.add((DataPoint)new Step(step.getTimestamp(), step.getX(), step.getY(), step.getMetaData()));
        }
        return result;
    }
}

