/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseDateTimeMsec;
import adams.core.base.BaseKeyValuePair;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class AddTrailStep
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected BaseDateTimeMsec m_Timestamp;
    protected float m_X;
    protected float m_Y;
    protected BaseKeyValuePair[] m_MetaData;

    public String globalInfo() {
        return "Adds a step to the trail passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new BaseDateTimeMsec());
        this.m_OptionManager.add("x", "X", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("y", "Y", (Object)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("meta-data", "metaData", (Object)new BaseKeyValuePair[0]);
    }

    public void setTimestamp(BaseDateTimeMsec value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public BaseDateTimeMsec getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The timestamp of the step to add.";
    }

    public void setX(float value) {
        if (this.getOptionManager().isValid("X", (Number)Float.valueOf(value))) {
            this.m_X = value;
            this.reset();
        }
    }

    public float getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X of the step to add.";
    }

    public void setY(float value) {
        if (this.getOptionManager().isValid("Y", (Number)Float.valueOf(value))) {
            this.m_Y = value;
            this.reset();
        }
    }

    public float getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y of the step to add.";
    }

    public void setMetaData(BaseKeyValuePair[] value) {
        this.m_MetaData = value;
        this.reset();
    }

    public BaseKeyValuePair[] getMetaData() {
        return this.m_MetaData;
    }

    public String metaDataTipText() {
        return "The (optional) meta-data to attached to the step.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"timestamp", (Object)this.m_Timestamp, (String)"timestamp: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)Float.valueOf(this.m_X), (String)", x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)Float.valueOf(this.m_Y), (String)", y: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Trail.class};
    }

    public Class[] generates() {
        return new Class[]{Trail.class};
    }

    protected String doExecute() {
        Trail trail = (Trail)((Object)this.m_InputToken.getPayload());
        Step step = new Step(this.m_Timestamp.dateValue(), this.m_X, this.m_Y);
        for (BaseKeyValuePair pair : this.m_MetaData) {
            step.addMetaData(pair.getPairKey(), pair.getPairValue());
        }
        trail.add((DataPoint)step);
        this.m_OutputToken = new Token((Object)trail);
        return null;
    }
}

