/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.QuadrilateralLocation;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ExtractTrackedObject
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected Field m_Location;

    public String globalInfo() {
        return "Extracts the tracked object and forwards it as a new image container.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("location", "location", (Object)new Field("Tracker.Current", DataType.STRING));
    }

    public void setLocation(Field value) {
        this.m_Location = value;
        this.reset();
    }

    public Field getLocation() {
        return this.m_Location;
    }

    public String locationTipText() {
        return "The field to retrieve the current location of the object from.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"location", (Object)this.m_Location, (String)"location: ");
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected BufferedImageContainer extract(AbstractImageContainer cont, QuadrilateralLocation location) {
        BufferedImageContainer result = new BufferedImageContainer();
        BufferedImage img = cont.toBufferedImage();
        Rectangle objLoc = location.rectangleValue();
        int x = Math.max(0, objLoc.x);
        int y = Math.max(0, objLoc.y);
        int width = objLoc.width - (x - objLoc.x);
        int height = objLoc.height - (y - objLoc.y);
        BufferedImage objImg = img.getSubimage(x, y, width, height);
        result.setImage((Object)objImg);
        result.setReport(cont.getReport().getClone());
        result.setNotes(cont.getNotes().getClone());
        return result;
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        QuadrilateralLocation location = null;
        if (cont.getReport().hasValue((AbstractField)this.m_Location)) {
            location = new QuadrilateralLocation(cont.getReport().getStringValue((AbstractField)this.m_Location));
        }
        if (location != null) {
            cont = this.extract(cont, location);
        }
        this.m_OutputToken = new Token((Object)cont);
        return result;
    }
}

