/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.filter.Filter;
import adams.data.filter.TrailWindow;
import adams.data.io.input.AbstractTrailReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.trail.Trail;
import adams.gui.chooser.TrailFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.SearchPanel;
import adams.gui.event.FilterEvent;
import adams.gui.event.FilterListener;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.plugin.ToolPluginSupporter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.FilterDialog;
import adams.gui.visualization.trail.TrailPanel;
import adams.gui.visualization.trail.overlay.AbstractTrailOverlay;
import adams.gui.visualization.trail.overlay.Null;
import adams.gui.visualization.trail.plugins.TrailViewerPluginManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrailViewerPanel
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
FilterListener<Trail>,
SendToActionSupporter,
CleanUpHandler,
ToolPluginSupporter<TrailPanel> {
    private static final long serialVersionUID = -2642034258827736757L;
    public static final String SESSION_FILE = "TrailViewerPanelSession.props";
    protected static Properties m_Properties;
    protected BaseTabbedPane m_TabbedPane;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileReloadCurrent;
    protected JMenuItem m_MenuItemFileReloadAll;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileCloseCurrent;
    protected JMenuItem m_MenuItemFileCloseAll;
    protected JMenuItem m_MenuItemProcessFilterTrail;
    protected JMenuItem m_MenuItemProcessFilterAllTrails;
    protected JMenuItem m_MenuItemViewOverlaysApplyAll;
    protected JMenuItem m_MenuItemViewRemoveOverlays;
    protected JMenuItem m_MenuItemViewAddOverlay;
    protected JMenu m_MenuViewZoom;
    protected JMenuItem m_MenuItemViewZoomIn;
    protected JMenuItem m_MenuItemViewZoomOut;
    protected TrailViewerPluginManager m_PluginManager;
    protected TrailFileChooser m_FileChooser;
    protected Filter<Trail> m_CurrentFilter;
    protected FilterDialog m_DialogFilter;
    protected boolean m_FilterOverlayOriginalData;
    protected boolean m_FilterAll;
    protected GenericObjectEditorDialog m_DialogOverlay;
    protected SearchPanel m_SearchPanel;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;

    protected void initialize() {
        super.initialize();
        Properties props = this.getProperties();
        this.m_FileChooser = new TrailFileChooser(props.getPath("InitialDir", "%h"));
        this.m_CurrentFilter = new TrailWindow();
        this.m_FilterAll = false;
        this.m_DialogOverlay = null;
        this.m_RecentFilesHandler = null;
        this.m_PluginManager = new TrailViewerPluginManager(this);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add(panel, "Center");
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_TabbedPane.setTabLayoutPolicy(1);
        this.m_TabbedPane.setCloseTabsWithMiddleMouseButton(true);
        this.m_TabbedPane.setShowCloseTabButton(true);
        panel.add((Component)this.m_TabbedPane, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", true, null);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                TrailViewerPanel.this.search(TrailViewerPanel.this.m_SearchPanel.getSearchText(), TrailViewerPanel.this.m_SearchPanel.isRegularExpression());
            }
        });
        JPanel panel2 = new JPanel(new FlowLayout(2));
        panel2.add((Component)this.m_SearchPanel);
        panel.add((Component)panel2, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            JMenuBar result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TrailViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.load();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, this.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    TrailViewerPanel.this.load(new File[]{((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile()}, (AbstractTrailReader)((Object)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler()));
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Reload current");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"F5"));
            menuitem.setIcon(GUIHelper.getIcon((String)"refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.reloadCurrent();
                }
            });
            this.m_MenuItemFileReloadCurrent = menuitem;
            menuitem = new JMenuItem("Reload all");
            menu.add(menuitem);
            menuitem.setMnemonic('e');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F5"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.reloadAll();
                }
            });
            this.m_MenuItemFileReloadAll = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.closeCurrent();
                }
            });
            this.m_MenuItemFileCloseCurrent = menuitem;
            menuitem = new JMenuItem("Close all tabs");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete_all.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.closeAll();
                }
            });
            this.m_MenuItemFileCloseAll = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.close();
                }
            });
            menu = new JMenu("Process");
            result.add(menu);
            menu.setMnemonic('P');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TrailViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter trail...");
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.m_FilterAll = false;
                    TrailViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterTrail = menuitem;
            menuitem = new JMenuItem("Filter all trails...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.m_FilterAll = true;
                    TrailViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterAllTrails = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TrailViewerPanel.this.updateMenu();
                }
            });
            submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setMnemonic('Z');
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            submenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TrailViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuViewZoom = submenu;
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed I"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.getCurrentPanel().getImagePanel().setScale(TrailViewerPanel.this.getCurrentPanel().getImagePanel().getScale() * 1.5);
                }
            });
            this.m_MenuItemViewZoomIn = menuitem;
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrailViewerPanel.this.getCurrentPanel().getImagePanel().setScale(TrailViewerPanel.this.getCurrentPanel().getImagePanel().getScale() / 1.5);
                }
            });
            this.m_MenuItemViewZoomOut = menuitem;
            int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800, 1600};
            String[] shortcuts = new String[]{"F", "", "", "", "", "1", "", "2", "4", "", ""};
            submenu.addSeparator();
            for (int i = 0; i < zooms.length; ++i) {
                final int fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                submenu.add(menuitem);
                if (shortcuts[i].length() > 0) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke((String)shortcuts[i]));
                }
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrailViewerPanel.this.zoom(fZoom);
                    }
                });
            }
            menuitem = new JCheckBoxMenuItem("Apply to all");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('A');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            this.m_MenuItemViewOverlaysApplyAll = menuitem;
            menuitem = new JMenuItem("Remove overlays");
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrailViewerPanel.this.m_MenuItemViewOverlaysApplyAll.isSelected()) {
                        for (int i = 0; i < TrailViewerPanel.this.getPanelCount(); ++i) {
                            TrailViewerPanel.this.getPanelAt(i).removeOverlays();
                        }
                    } else {
                        TrailViewerPanel.this.getCurrentPanel().removeOverlays();
                    }
                }
            });
            this.m_MenuItemViewRemoveOverlays = menuitem;
            menuitem = new JMenuItem("Add overlay...");
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('d');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractTrailOverlay overlay = TrailViewerPanel.this.selectOverlay();
                    if (overlay == null) {
                        return;
                    }
                    if (TrailViewerPanel.this.m_MenuItemViewOverlaysApplyAll.isSelected()) {
                        for (int i = 0; i < TrailViewerPanel.this.getPanelCount(); ++i) {
                            TrailViewerPanel.this.getPanelAt(i).addOverlay(overlay);
                        }
                    } else {
                        TrailViewerPanel.this.getCurrentPanel().addOverlay(overlay);
                    }
                }
            });
            this.m_MenuItemViewAddOverlay = menuitem;
            this.m_PluginManager.addToMenuBar(result);
            this.m_MenuBar = result;
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    public int getPanelCount() {
        return this.m_TabbedPane.getTabCount();
    }

    public TrailPanel getPanelAt(int index) {
        TrailPanel result = null;
        if (index != -1) {
            result = (TrailPanel)((Object)this.m_TabbedPane.getComponentAt(index));
        }
        return result;
    }

    public TrailPanel getCurrentPanel() {
        return this.getPanelAt(this.m_TabbedPane.getSelectedIndex());
    }

    public TrailPanel[] getAllPanels() {
        ArrayList<TrailPanel> result = new ArrayList<TrailPanel>();
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            result.add(this.getPanelAt(i));
        }
        return result.toArray(new TrailPanel[result.size()]);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.m_TabbedPane.getTabCount() > 0;
        this.m_MenuItemFileSaveAs.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileReloadCurrent.setEnabled(dataLoaded && this.getCurrentPanel().canReload());
        this.m_MenuItemFileReloadAll.setEnabled(dataLoaded);
        this.m_MenuItemFileCloseCurrent.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileCloseAll.setEnabled(dataLoaded);
        this.m_MenuItemProcessFilterTrail.setEnabled(dataLoaded);
        this.m_MenuItemProcessFilterAllTrails.setEnabled(dataLoaded);
        this.m_MenuViewZoom.setEnabled(dataLoaded);
        this.m_MenuItemViewZoomIn.setEnabled(dataLoaded);
        this.m_MenuItemViewZoomOut.setEnabled(dataLoaded);
        this.m_MenuItemViewAddOverlay.setEnabled(dataLoaded);
        this.m_MenuItemViewOverlaysApplyAll.setEnabled(dataLoaded);
        this.m_MenuItemViewRemoveOverlays.setEnabled(dataLoaded);
        this.m_PluginManager.updateMenu();
    }

    protected void reloadCurrent() {
        TrailPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.reload();
        this.m_TabbedPane.setTitleAt(this.m_TabbedPane.getSelectedIndex(), panel.getTitle());
    }

    protected void reloadAll() {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            TrailPanel panel = this.getPanelAt(i);
            panel.reload();
            this.m_TabbedPane.setTitleAt(i, panel.getTitle());
        }
    }

    public void closeCurrent() {
        if (this.m_TabbedPane.getSelectedIndex() != -1) {
            this.m_TabbedPane.removeTabAt(this.m_TabbedPane.getSelectedIndex());
        }
    }

    public void closeAll() {
        this.m_TabbedPane.removeAll();
    }

    protected TrailPanel newPanel(Trail map) {
        TrailPanel result = new TrailPanel(this);
        result.setSearchPanelVisible(false);
        result.setTrail(map);
        return result;
    }

    public void load(File[] files, final AbstractTrailReader reader) {
        for (final File file : files) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    TrailViewerPanel.this.showStatus("Loading file: " + file);
                    reader.setInput(new PlaceholderFile(file));
                    List maps = reader.read();
                    if (maps.size() == 0) {
                        GUIHelper.showErrorMessage((Component)((Object)TrailViewerPanel.this), (String)("Failed to read trail from:\n" + reader.getInput()));
                        TrailViewerPanel.this.showStatus("");
                        return;
                    }
                    TrailPanel panel = TrailViewerPanel.this.newPanel((Trail)((Object)maps.get(0)));
                    panel.log("Load: " + file);
                    panel.setReader(reader);
                    TrailViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    TrailViewerPanel.this.m_TabbedPane.setSelectedComponent((Component)((Object)panel));
                    TrailViewerPanel.this.showStatus("");
                    if (TrailViewerPanel.this.m_RecentFilesHandler != null) {
                        TrailViewerPanel.this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        this.showStatus("");
    }

    public void load(File file) {
        AbstractTrailReader reader = (AbstractTrailReader)this.m_FileChooser.getReaderForFile(file);
        if (reader == null) {
            this.m_FileChooser.setSelectedFile(file);
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to automatically determine reader for file, please choose appropriate one:\n" + file));
            this.load();
            return;
        }
        this.load(new File[]{file}, reader);
    }

    public void load() {
        this.m_FileChooser.setMultiSelectionEnabled(true);
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.load(this.m_FileChooser.getSelectedFiles(), (AbstractTrailReader)((Object)this.m_FileChooser.getReader()));
    }

    protected void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        Trail map = this.getCurrentPanel().getTrail();
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        AbstractDataContainerWriter writer = (AbstractDataContainerWriter)this.m_FileChooser.getWriter();
        writer.setOutput(file);
        if (!writer.write((DataContainer)map)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write trail to '" + file + "'!\nCheck console for error message."));
        }
    }

    public void close() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    protected void filter() {
        if (this.m_DialogFilter == null) {
            this.m_DialogFilter = this.getParentDialog() != null ? new FilterDialog(this.getParentDialog()) : new FilterDialog(this.getParentFrame());
            this.m_DialogFilter.setFilterListener((FilterListener)this);
        }
        this.m_DialogFilter.setFilter(this.m_CurrentFilter);
        this.m_DialogFilter.setOverlayOriginalData(this.m_FilterOverlayOriginalData);
        this.m_DialogFilter.setLocationRelativeTo((Component)((Object)this));
        this.m_DialogFilter.setVisible(true);
    }

    public void filter(final FilterEvent<Trail> e) {
        int i;
        int[] indices;
        this.m_CurrentFilter = e.getFilter();
        this.m_FilterOverlayOriginalData = e.getOverlayOriginalData();
        int count = this.m_TabbedPane.getTabCount();
        if (this.m_FilterAll) {
            indices = new int[count];
            for (i = 0; i < count; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[]{this.m_TabbedPane.getSelectedIndex()};
        }
        for (i = 0; i < indices.length; ++i) {
            final int index = indices[i];
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Filter filter = e.getFilter().shallowCopy();
                    TrailPanel panel = TrailViewerPanel.this.getPanelAt(index);
                    Trail filtered = (Trail)filter.filter((DataContainer)panel.getTrail());
                    filter.cleanUp();
                    panel.log("Filter: " + filter.toCommandLine());
                    if (e.getOverlayOriginalData()) {
                        panel = TrailViewerPanel.this.newPanel(filtered);
                        TrailViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    } else {
                        panel.setTrail(filtered);
                        TrailViewerPanel.this.m_TabbedPane.setTitleAt(index, panel.getTitle());
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    public void search(String text, boolean isRegExp) {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            this.getPanelAt(i).search(text, isRegExp);
        }
    }

    protected void zoom(int zoom) {
        this.getCurrentPanel().setZoom((double)zoom / 100.0);
    }

    protected AbstractTrailOverlay selectOverlay() {
        if (this.m_DialogOverlay == null) {
            this.m_DialogOverlay = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogOverlay.setTitle("Select overlay");
            this.m_DialogOverlay.getGOEEditor().setClassType(AbstractTrailOverlay.class);
            this.m_DialogOverlay.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogOverlay.setCurrent((Object)new Null());
            this.m_DialogOverlay.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_DialogOverlay.setVisible(true);
        if (this.m_DialogOverlay.getResult() != 0) {
            return null;
        }
        return (AbstractTrailOverlay)((Object)this.m_DialogOverlay.getCurrent());
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public Class[] getSendToClasses() {
        return new Class[]{JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getCurrentPanel() != null;
    }

    public Object getSendToItem(Class[] cls) {
        TrailPanel result = null;
        if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getCurrentPanel() != null) {
            result = this.getCurrentPanel();
        }
        return result;
    }

    public synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                String props = ((Object)((Object)this)).getClass().getName().replaceAll("\\.", "/") + ".props";
                m_Properties = Properties.read((String)props);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public void cleanUp() {
        if (this.m_DialogOverlay != null) {
            this.m_DialogOverlay.dispose();
            this.m_DialogOverlay = null;
        }
        if (this.m_DialogFilter != null) {
            this.m_DialogFilter.dispose();
            this.m_DialogFilter = null;
        }
    }
}

