/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.io.File;

public class MovieInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = 2225032460979700294L;
    protected InfoType m_Type;
    protected Index m_StreamIndex;

    public String globalInfo() {
        return "Outputs basic information about a video and its audio/video streams.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.MOVIE_DURATION);
        this.m_OptionManager.add("stream-index", "streamIndex", (Object)new Index("first"));
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of info to retrieve.";
    }

    public void setStreamIndex(Index value) {
        this.m_StreamIndex = value;
        this.reset();
    }

    public Index getStreamIndex() {
        return this.m_StreamIndex;
    }

    public String streamIndexTipText() {
        return "The index of the stream to retrieve the information for.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"streamIndex", (Object)this.m_StreamIndex, (String)", stream: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case NUM_STREAMS: 
            case BITRATE: 
            case AUDIO_CHANNELS: 
            case VIDEO_WIDTH: 
            case VIDEO_HEIGHT: 
            case AUDIO_SAMPLE_RATE: {
                return new Class[]{Integer.class};
            }
            case MOVIE_DURATION: 
            case STREAM_DURATION: 
            case MOVIE_START_TIME: 
            case STREAM_START_TIME: {
                return new Class[]{Long.class};
            }
            case STREAM_TIME_BASE: 
            case CODER_TIME_BASE: 
            case VIDEO_FRAME_RATE: {
                return new Class[]{Double.class};
            }
            case CODEC_TYPE: 
            case CODEC_ID: 
            case LANGUAGE: 
            case VIDEO_FORMAT: 
            case AUDIO_FORMAT: {
                return new Class[]{String.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        String filename = this.m_InputToken.getPayload() instanceof File ? ((File)this.m_InputToken.getPayload()).getAbsolutePath() : (String)this.m_InputToken.getPayload();
        filename = new PlaceholderFile(filename).getAbsolutePath();
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            result = "Failed to open movie file: " + filename;
        }
        if (result == null) {
            IStream stream = null;
            IStreamCoder coder = null;
            this.m_StreamIndex.setMax(container.getNumStreams());
            switch (this.m_Type) {
                case AUDIO_CHANNELS: 
                case VIDEO_WIDTH: 
                case VIDEO_HEIGHT: 
                case AUDIO_SAMPLE_RATE: 
                case STREAM_DURATION: 
                case STREAM_START_TIME: 
                case STREAM_TIME_BASE: 
                case CODER_TIME_BASE: 
                case VIDEO_FRAME_RATE: 
                case CODEC_TYPE: 
                case CODEC_ID: 
                case LANGUAGE: 
                case VIDEO_FORMAT: 
                case AUDIO_FORMAT: {
                    stream = container.getStream((long)this.m_StreamIndex.getIntIndex());
                    coder = stream.getStreamCoder();
                }
            }
            switch (this.m_Type) {
                case MOVIE_DURATION: {
                    this.m_OutputToken = new Token((Object)container.getDuration());
                    break;
                }
                case MOVIE_START_TIME: {
                    this.m_OutputToken = new Token((Object)container.getStartTime());
                    break;
                }
                case BITRATE: {
                    this.m_OutputToken = new Token((Object)container.getBitRate());
                    break;
                }
                case NUM_STREAMS: {
                    this.m_OutputToken = new Token((Object)container.getNumStreams());
                    break;
                }
                case LANGUAGE: {
                    this.m_OutputToken = new Token((Object)stream.getLanguage());
                    break;
                }
                case STREAM_DURATION: {
                    this.m_OutputToken = new Token((Object)stream.getDuration());
                    break;
                }
                case STREAM_START_TIME: {
                    this.m_OutputToken = new Token((Object)stream.getStartTime());
                    break;
                }
                case STREAM_TIME_BASE: {
                    this.m_OutputToken = new Token((Object)((double)stream.getTimeBase().getNumerator() / (double)stream.getTimeBase().getDenominator()));
                    break;
                }
                case CODER_TIME_BASE: {
                    this.m_OutputToken = new Token((Object)((double)coder.getTimeBase().getNumerator() / (double)coder.getTimeBase().getDenominator()));
                    break;
                }
                case CODEC_TYPE: {
                    this.m_OutputToken = new Token((Object)coder.getCodecType().toString());
                    break;
                }
                case CODEC_ID: {
                    this.m_OutputToken = new Token((Object)coder.getCodecID().toString());
                    break;
                }
                case AUDIO_SAMPLE_RATE: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) break;
                    this.m_OutputToken = new Token((Object)coder.getSampleRate());
                    break;
                }
                case AUDIO_CHANNELS: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) break;
                    this.m_OutputToken = new Token((Object)coder.getChannels());
                    break;
                }
                case AUDIO_FORMAT: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) break;
                    this.m_OutputToken = new Token((Object)coder.getSampleFormat());
                    break;
                }
                case VIDEO_WIDTH: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) break;
                    this.m_OutputToken = new Token((Object)coder.getWidth());
                    break;
                }
                case VIDEO_HEIGHT: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) break;
                    this.m_OutputToken = new Token((Object)coder.getHeight());
                    break;
                }
                case VIDEO_FORMAT: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) break;
                    this.m_OutputToken = new Token((Object)coder.getPixelType().toString());
                    break;
                }
                case VIDEO_FRAME_RATE: {
                    if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) break;
                    this.m_OutputToken = new Token((Object)coder.getFrameRate().getDouble());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
                }
            }
            container.close();
        }
        return result;
    }

    public static enum InfoType {
        MOVIE_DURATION,
        MOVIE_START_TIME,
        BITRATE,
        NUM_STREAMS,
        STREAM_DURATION,
        STREAM_START_TIME,
        CODEC_TYPE,
        CODEC_ID,
        LANGUAGE,
        STREAM_TIME_BASE,
        CODER_TIME_BASE,
        AUDIO_SAMPLE_RATE,
        AUDIO_CHANNELS,
        AUDIO_FORMAT,
        VIDEO_WIDTH,
        VIDEO_HEIGHT,
        VIDEO_FORMAT,
        VIDEO_FRAME_RATE;

    }
}

