/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.QuadrilateralLocation;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.objecttracker.BoofCVCirculant;
import adams.flow.transformer.objecttracker.ObjectTracker;
import java.util.List;

public class TrackObjects
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected ObjectTracker m_Algorithm;

    public String globalInfo() {
        return "Tracks objects in images using the provided tracker algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new BoofCVCirculant());
    }

    public void setAlgorithm(ObjectTracker value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public ObjectTracker getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The object tracking algorithm to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm, (String)"algorithm: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        if (!this.m_Algorithm.isInitialized()) {
            result = this.m_Algorithm.initTracking(cont);
        } else {
            List<QuadrilateralLocation> locations = this.m_Algorithm.trackObjects(cont);
            if (locations == null) {
                result = "Failed to track object(s)!";
            }
        }
        this.m_OutputToken = new Token((Object)cont);
        return result;
    }
}

