/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.movieimagesampler;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseTimeMsec;
import adams.core.logging.LoggingSupporter;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.transformer.movieimagesampler.AbstractBufferedImageMovieImageSampler;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IError;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

@MixedCopyright(author="Xuggle-Xuggler-Main", license=License.LGPL3, url="http://xuggle.googlecode.com/svn/trunk/java/xuggle-xuggler/src/com/xuggle/mediatool/demos/DecodeAndCaptureFrames.java")
public class FixedIntervalBufferedImageSampler
extends AbstractBufferedImageMovieImageSampler {
    private static final long serialVersionUID = -3415741990134536419L;
    protected int m_NumSamples;
    protected BaseTimeMsec m_Offset;
    protected int m_Interval;
    protected transient IMediaReader m_Reader;
    protected transient MediaListenerAdapter m_Listener;
    protected long m_LastPtsWrite;
    protected long m_MicroSecondsBetweenFrames;
    protected int m_VideoStreamIndex;
    protected List<BufferedImageContainer> m_Samples;

    public String globalInfo() {
        return "Generates a specified number of image samples at fixed intervals.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("offset", "offset", (Object)new BaseTimeMsec("-INF"));
        this.m_OptionManager.add("interval", "interval", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("num-samples", "numSamples", (Object)10, (Number)1, null);
    }

    public void setOffset(BaseTimeMsec value) {
        this.m_Offset = value;
        this.reset();
    }

    public BaseTimeMsec getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset for the samples, i.e., before starting the sampling.";
    }

    public void setInterval(int value) {
        if (this.getOptionManager().isValid("interval", (Number)value)) {
            this.m_Interval = value;
            this.reset();
        }
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval in milli-seconds between samples.";
    }

    public void setNumSamples(int value) {
        if (this.getOptionManager().isValid("numSamples", (Number)value)) {
            this.m_NumSamples = value;
            this.reset();
        }
    }

    public int getNumSamples() {
        return this.m_NumSamples;
    }

    public String numSamplesTipText() {
        return "The number of samples to take.";
    }

    protected BufferedImageContainer[] doSample(File file) {
        this.m_Samples = new ArrayList<BufferedImageContainer>();
        this.m_LastPtsWrite = Global.NO_PTS;
        this.m_VideoStreamIndex = -1;
        this.m_MicroSecondsBetweenFrames = Global.DEFAULT_PTS_PER_SECOND * (long)this.m_Interval / 1000L;
        try {
            this.m_Reader = ToolFactory.makeReader((String)file.getAbsolutePath());
            this.m_Reader.setBufferedImageTypeToGenerate(5);
            this.m_Listener = new MediaListenerAdapter(){

                public void onVideoPicture(IVideoPictureEvent event) {
                    if (FixedIntervalBufferedImageSampler.this.m_Stopped) {
                        FixedIntervalBufferedImageSampler.this.m_Reader.close();
                        return;
                    }
                    try {
                        if (event.getStreamIndex() != FixedIntervalBufferedImageSampler.this.m_VideoStreamIndex) {
                            if (FixedIntervalBufferedImageSampler.this.m_VideoStreamIndex == -1) {
                                FixedIntervalBufferedImageSampler.this.m_VideoStreamIndex = event.getStreamIndex();
                            } else {
                                return;
                            }
                        }
                        if (FixedIntervalBufferedImageSampler.this.m_LastPtsWrite == Global.NO_PTS) {
                            FixedIntervalBufferedImageSampler.this.m_LastPtsWrite = FixedIntervalBufferedImageSampler.this.m_Offset.isInfinity() ? event.getTimeStamp() + FixedIntervalBufferedImageSampler.this.m_MicroSecondsBetweenFrames : event.getTimeStamp() + FixedIntervalBufferedImageSampler.this.m_Offset.dateValue().getTime() - FixedIntervalBufferedImageSampler.this.m_MicroSecondsBetweenFrames;
                        }
                        if (event.getTimeStamp() - FixedIntervalBufferedImageSampler.this.m_LastPtsWrite >= FixedIntervalBufferedImageSampler.this.m_MicroSecondsBetweenFrames) {
                            BufferedImageContainer cont = new BufferedImageContainer();
                            cont.setImage((Object)event.getImage());
                            Field field = new Field("Frame", DataType.NUMERIC);
                            cont.getReport().addField((AbstractField)field);
                            cont.getReport().setValue((AbstractField)field, (Object)event.getStreamIndex());
                            field = new Field("Timestamp", DataType.STRING);
                            DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
                            cont.getReport().addField((AbstractField)field);
                            cont.getReport().setValue((AbstractField)field, (Object)dformat.format(new Date(event.getTimeStamp(TimeUnit.MILLISECONDS))));
                            FixedIntervalBufferedImageSampler.this.m_Samples.add(cont);
                            FixedIntervalBufferedImageSampler.this.m_LastPtsWrite += FixedIntervalBufferedImageSampler.this.m_MicroSecondsBetweenFrames;
                            if (FixedIntervalBufferedImageSampler.this.m_Samples.size() == FixedIntervalBufferedImageSampler.this.m_NumSamples) {
                                FixedIntervalBufferedImageSampler.this.m_Reader.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        Utils.handleException((LoggingSupporter)FixedIntervalBufferedImageSampler.this, (String)"Failed to process video event!", (Throwable)e);
                    }
                }
            };
            this.m_Reader.addListener((IMediaListener)this.m_Listener);
            do {
                IError error;
                if ((error = this.m_Reader.readPacket()) == null) continue;
                this.getLogger().severe("Failed to start reading: " + error.toString());
                break;
            } while (this.m_Reader.isOpen());
            this.m_Reader.removeListener((IMediaListener)this.m_Listener);
            if (this.m_Reader.isOpen()) {
                this.m_Reader.close();
            }
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)("Failed to open video file: " + file), (Throwable)e);
        }
        return this.m_Samples.toArray(new BufferedImageContainer[this.m_Samples.size()]);
    }
}

