/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail;

import adams.core.Properties;
import adams.data.conversion.TrailToSpreadSheet;
import adams.data.io.input.AbstractTrailReader;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Trail;
import adams.gui.core.BaseLogPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.paintlet.Paintlet;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.trail.TrailViewerPanel;
import adams.gui.visualization.trail.overlay.AbstractTrailOverlay;
import adams.gui.visualization.trail.paintlet.AbstractTrailPaintlet;
import adams.gui.visualization.trail.paintlet.Circles;
import adams.gui.visualization.trail.paintlet.TrailPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class TrailPanel
extends BasePanel {
    private static final long serialVersionUID = 1897625268125110563L;
    protected static Properties m_Properties;
    protected Trail m_Trail;
    protected ImagePanel m_TrailImage;
    protected SpreadSheetTable m_TrailTable;
    protected ReportFactory.Table m_ReportTable;
    protected SearchPanel m_SearchPanel;
    protected BaseTabbedPane m_LogTabbedPane;
    protected BaseSplitPane m_SplitPane;
    protected BaseTabbedPane m_TabbedPane;
    protected TrailViewerPanel m_Owner;
    protected AbstractTrailReader m_Reader;
    protected BaseLogPanel m_PanelLog;
    protected TrailPaintlet m_TrailPaintlet;

    public TrailPanel(TrailViewerPanel owner) {
        this.m_Owner = owner;
    }

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
        this.m_Trail = new Trail();
        this.m_Reader = null;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = TrailPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_LogTabbedPane = new BaseTabbedPane();
        this.m_LogTabbedPane.setTabPlacement(3);
        this.add((Component)this.m_LogTabbedPane, "Center");
        this.m_SplitPane = new BaseSplitPane();
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setDividerLocation(props.getInteger("Panel.DividerLocation", Integer.valueOf(700)).intValue());
        this.m_LogTabbedPane.addTab("Data", (Component)this.m_SplitPane);
        this.m_TrailImage = new ImagePanel();
        this.m_TrailTable = null;
        if (props.getBoolean("SpreadSheet.Show", Boolean.valueOf(true)).booleanValue()) {
            this.m_TabbedPane = new BaseTabbedPane();
            this.m_SplitPane.setLeftComponent((Component)this.m_TabbedPane);
            this.m_TabbedPane.addTab("View", (Component)this.m_TrailImage);
            this.m_TrailTable = new SpreadSheetTable((SpreadSheet)new DefaultSpreadSheet());
            this.m_TrailTable.setNumDecimals(props.getInteger("SpreadSheet.NumDecimals", Integer.valueOf(3)).intValue());
            this.m_TabbedPane.addTab("Trail", (Component)new BaseScrollPane((Component)this.m_TrailTable));
        } else {
            this.m_SplitPane.setLeftComponent((Component)this.m_TrailImage);
        }
        this.m_TrailPaintlet = AbstractTrailPaintlet.forCommandLine(props.getProperty("Image.Paintlet", ""));
        if (this.m_TrailPaintlet == null) {
            this.m_TrailPaintlet = new Circles();
        }
        this.m_TrailImage.addPaintlet((Paintlet)this.m_TrailPaintlet);
        this.m_TrailPaintlet.setPanel(this);
        this.m_ReportTable = new ReportFactory.Table();
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", true, null);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                TrailPanel.this.search(TrailPanel.this.m_SearchPanel.getSearchText(), TrailPanel.this.m_SearchPanel.isRegularExpression());
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new BaseScrollPane((Component)this.m_ReportTable), "Center");
        panel.add((Component)this.m_SearchPanel, "South");
        this.m_SplitPane.setRightComponent((Component)panel);
        this.m_PanelLog = new BaseLogPanel();
        this.m_PanelLog.setRows(5);
        this.m_PanelLog.setColumns(80);
        this.m_LogTabbedPane.addTab("Log", (Component)this.m_PanelLog);
    }

    public TrailViewerPanel getOwner() {
        return this.m_Owner;
    }

    public void setPaintlet(TrailPaintlet value) {
        if (this.m_TrailPaintlet != null) {
            this.m_TrailImage.removePaintlet((Paintlet)this.m_TrailPaintlet);
            this.m_TrailPaintlet.setPanel(null);
        }
        this.m_TrailPaintlet = value;
        this.m_TrailImage.addPaintlet((Paintlet)this.m_TrailPaintlet);
        this.m_TrailPaintlet.setPanel(this);
    }

    public TrailPaintlet getPaintlet() {
        return this.m_TrailPaintlet;
    }

    protected String refresh() {
        if (this.m_Trail.getWidth().floatValue() == 0.0f) {
            return null;
        }
        this.m_TrailImage.repaint();
        return null;
    }

    public void setTrail(Trail value) {
        if (value == null) {
            return;
        }
        this.m_Trail = (Trail)((Object)value.getClone());
        Properties props = TrailPanel.getProperties();
        StringBuilder errors = new StringBuilder();
        if (!this.m_Trail.hasBackground()) {
            this.m_Trail.newBackground();
        }
        this.m_TrailImage.setCurrentImage(this.m_Trail.getBackground());
        String error = this.refresh();
        if (error != null) {
            errors.append(error);
        }
        if (this.m_TrailTable != null) {
            TrailToSpreadSheet hm2ss = new TrailToSpreadSheet();
            hm2ss.setInput((Object)this.m_Trail);
            String result = hm2ss.convert();
            if (result != null) {
                error = "Failed to generate spreadsheet: " + result;
                if (errors.length() > 0) {
                    errors.append("\n");
                }
                errors.append(error);
                System.err.println(error);
                this.m_TrailTable.setModel((TableModel)new SpreadSheetTableModel());
            } else {
                this.m_TrailTable.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)hm2ss.getOutput()));
            }
            this.m_TrailTable.setNumDecimals(props.getInteger("SpreadSheet.NumDecimals", Integer.valueOf(3)).intValue());
        }
        this.m_ReportTable.setModel((TableModel)new ReportFactory.Model(this.m_Trail.getReport()));
        if (errors.length() > 0 && this.m_Owner != null) {
            this.m_Owner.showStatus(errors.toString());
        }
    }

    public Trail getTrail() {
        return this.m_Trail;
    }

    public void setReader(AbstractTrailReader value) {
        this.m_Reader = (AbstractTrailReader)value.shallowCopy(true);
    }

    public AbstractTrailReader getReader() {
        return this.m_Reader;
    }

    public void addOverlay(AbstractTrailOverlay overlay) {
        overlay = (AbstractTrailOverlay)overlay.shallowCopy();
        overlay.setTrailPanel(this);
        this.getImagePanel().addImageOverlay((ImageOverlay)overlay);
    }

    public void removeOverlays() {
        this.getImagePanel().clearImageOverlays();
    }

    public String getTitle() {
        return this.m_Trail.getID();
    }

    public ImagePanel getImagePanel() {
        return this.m_TrailImage;
    }

    public boolean canReload() {
        boolean result = false;
        Report report = this.m_Trail.getReport();
        return result;
    }

    public boolean reload() {
        Report report = this.m_Trail.getReport();
        return false;
    }

    public void search(String text, boolean isRegExp) {
        this.m_ReportTable.search(text, isRegExp);
    }

    public void setSearchPanelVisible(boolean value) {
        this.m_SearchPanel.setVisible(value);
    }

    public boolean isSearchPanelVisible() {
        return this.m_SearchPanel.isVisible();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                String props = TrailPanel.class.getName().replaceAll("\\.", "/") + ".props";
                m_Properties = Properties.read((String)props);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public void setZoom(double zoom) {
        this.m_TrailImage.setScale(zoom);
    }

    public double getZoom() {
        return this.m_TrailImage.getScale();
    }

    public void log(String msg) {
        this.m_PanelLog.append(msg);
    }
}

