/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.data.video.AbstractRecorder;
import adams.data.video.XuggleScreenRecorder;
import adams.flow.standalone.AbstractStandalone;
import com.github.fracpete.screencast4j.record.Recorder;
import java.util.Hashtable;

public class RecordingSetup
extends AbstractStandalone {
    private static final long serialVersionUID = -7820311755817280084L;
    public static final String BACKUP_RECORDER = "recorder";
    protected AbstractRecorder m_Recorder;
    protected transient Recorder m_ActualRecorder;

    public String globalInfo() {
        return "Defines a recording setup for sound and video.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_RECORDER, BACKUP_RECORDER, (Object)new XuggleScreenRecorder());
    }

    public void setRecorder(AbstractRecorder value) {
        this.m_Recorder = value;
        this.reset();
    }

    public AbstractRecorder getRecorder() {
        return this.m_Recorder;
    }

    public String recorderTipText() {
        return "The recorder setup to use.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_RECORDER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualRecorder != null) {
            result.put(BACKUP_RECORDER, this.m_ActualRecorder);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_RECORDER)) {
            this.m_ActualRecorder = (Recorder)state.get(BACKUP_RECORDER);
            state.remove(BACKUP_RECORDER);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_ActualRecorder = this.m_Recorder.configure();
        }
        catch (Exception e) {
            result = this.handleException("Failed to initialize recording setup:", e);
        }
        return result;
    }

    public void startRecording() {
        if (this.m_ActualRecorder != null) {
            this.m_ActualRecorder.start();
        }
    }

    public void stopRecording() {
        if (this.m_ActualRecorder != null) {
            this.m_ActualRecorder.stop();
            this.m_ActualRecorder.cleanUp();
            this.m_ActualRecorder = null;
        }
    }

    public void stopExecution() {
        this.stopRecording();
        super.stopExecution();
    }

    public void wrapUp() {
        this.stopRecording();
        super.wrapUp();
    }
}

