/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.movieimagesampler;

import adams.core.Stoppable;
import adams.core.option.AbstractOptionHandler;
import adams.data.image.AbstractImageContainer;
import java.io.File;

public abstract class AbstractMovieImageSampler<T extends AbstractImageContainer>
extends AbstractOptionHandler
implements Stoppable {
    private static final long serialVersionUID = -8088693094272652760L;
    protected boolean m_Stopped;

    public abstract Class generates();

    protected void check(File file) {
        if (!file.exists()) {
            throw new IllegalStateException("Movie does not exist: " + file);
        }
        if (file.isDirectory()) {
            throw new IllegalStateException("Movie file points to a directory: " + file);
        }
    }

    protected abstract T[] doSample(File var1);

    public T[] sample(File file) {
        this.m_Stopped = false;
        this.check(file);
        AbstractImageContainer[] result = this.doSample(file);
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }
}

