/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.movieimagesampler;

import adams.core.base.BaseTimeMsec;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.transformer.movieimagesampler.AbstractBufferedImageMovieImageSampler;
import adams.gui.visualization.video.vlcjplayer.VideoUtilities;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.condition.conditions.PausedCondition;
import uk.co.caprica.vlcj.player.condition.conditions.PlayingCondition;
import uk.co.caprica.vlcj.player.condition.conditions.TimeReachedCondition;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.direct.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;

public class TimestampMovieSampler
extends AbstractBufferedImageMovieImageSampler {
    protected long[] m_TimeStampsLong;
    protected BaseTimeMsec[] m_Timestamps;
    protected DirectMediaPlayer m_MediaPlayer;
    protected long m_TargetTime;
    protected List<BufferedImageContainer> m_Samples;
    protected MediaPlayerFactory m_Factory;
    protected Dimension m_VideoDimension;
    protected BufferedImage m_Image;
    protected BufferedImageContainer m_CurrentImage;
    protected BufferedImageContainer m_PreviousImage;
    protected long m_TimeOffset;

    protected void reset() {
        super.reset();
        this.m_TimeStampsLong = null;
    }

    public void setTimeStamps(BaseTimeMsec[] timeStamps) {
        this.m_Timestamps = timeStamps;
        this.reset();
    }

    public BaseTimeMsec[] getTimeStamps() {
        return this.m_Timestamps;
    }

    public void setTimeStampsAsLong(long[] timeStamps) {
        this.m_TimeStampsLong = timeStamps;
    }

    public long[] getTimeStampsAsLong() {
        if (this.m_TimeStampsLong == null) {
            this.m_TimeOffset = new BaseTimeMsec("00:00:00.000").dateValue().getTime();
            Calendar calendar = Calendar.getInstance();
            long hours = 0L;
            long minutes = 0L;
            long seconds = 0L;
            long mseconds = 0L;
            this.m_TimeStampsLong = new long[this.m_Timestamps.length];
            int i = 0;
            while (i < this.m_Timestamps.length) {
                calendar.setTime(this.m_Timestamps[i].dateValue());
                hours = calendar.get(11);
                minutes = calendar.get(12);
                seconds = calendar.get(13);
                mseconds = calendar.get(14);
                int n = i;
                this.m_TimeStampsLong[n] = this.m_TimeStampsLong[n] + hours * 3600000L;
                int n2 = i;
                this.m_TimeStampsLong[n2] = this.m_TimeStampsLong[n2] + minutes * 60000L;
                int n3 = i;
                this.m_TimeStampsLong[n3] = this.m_TimeStampsLong[n3] + seconds * 1000L;
                int n4 = i++;
                this.m_TimeStampsLong[n4] = this.m_TimeStampsLong[n4] + mseconds;
            }
        }
        return this.m_TimeStampsLong;
    }

    public String timeStampsTipText() {
        return "The timestamps to capture images at.";
    }

    public String globalInfo() {
        return "Generates an image at each of the provided timestamps";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp", "timeStamps", (Object)new BaseTimeMsec[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImage = new BufferedImageContainer();
        this.m_PreviousImage = new BufferedImageContainer();
    }

    protected BufferedImageContainer[] doSample(final File file) {
        long[] timestamps = this.getTimeStampsAsLong();
        this.m_VideoDimension = VideoUtilities.getVideoDimensions(file.getAbsolutePath());
        this.m_Image = new BufferedImage((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight(), 1);
        this.m_Factory = new MediaPlayerFactory();
        BufferFormatCallback bufferFormatCallback = (i, i1) -> new RV32BufferFormat((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight());
        this.m_MediaPlayer = this.m_Factory.newDirectMediaPlayer(bufferFormatCallback, (RenderCallback)new SnapshotRenderCallback());
        this.m_Samples = new ArrayList<BufferedImageContainer>();
        try {
            PlayingCondition playingCondition = new PlayingCondition((MediaPlayer)this.m_MediaPlayer){

                protected boolean onBefore() {
                    return TimestampMovieSampler.this.m_MediaPlayer.startMedia(file.getAbsolutePath(), new String[0]);
                }
            };
            playingCondition.await();
            for (int i2 = 0; i2 < timestamps.length; ++i2) {
                System.out.println("Ding " + timestamps[i2]);
                this.m_TargetTime = timestamps[i2];
                if (this.m_TargetTime <= this.m_MediaPlayer.getLength()) {
                    TimeReachedCondition timeReachedCondition = new TimeReachedCondition((MediaPlayer)this.m_MediaPlayer, this.m_TargetTime){

                        protected boolean onBefore() {
                            TimestampMovieSampler.this.m_MediaPlayer.setTime(this.targetTime);
                            return true;
                        }
                    };
                    timeReachedCondition.await();
                    PausedCondition pausedCondition = new PausedCondition((MediaPlayer)this.m_MediaPlayer){

                        protected boolean onBefore() {
                            TimestampMovieSampler.this.m_MediaPlayer.pause();
                            return true;
                        }
                    };
                    pausedCondition.await();
                    playingCondition = new PlayingCondition((MediaPlayer)this.m_MediaPlayer){

                        protected boolean onBefore() {
                            TimestampMovieSampler.this.m_MediaPlayer.play();
                            return true;
                        }
                    };
                    playingCondition.await();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.m_MediaPlayer.release();
        this.m_Factory.release();
        return this.m_Samples.toArray(new BufferedImageContainer[this.m_Samples.size()]);
    }

    private class SnapshotRenderCallback
    extends RenderCallbackAdapter {
        SnapshotRenderCallback() {
            super(new int[(int)TimestampMovieSampler.this.m_VideoDimension.getWidth() * (int)TimestampMovieSampler.this.m_VideoDimension.getHeight()]);
        }

        protected void onDisplay(DirectMediaPlayer directMediaPlayer, int[] rgbBuffer) {
            TimestampMovieSampler.this.m_Image = new BufferedImage((int)TimestampMovieSampler.this.m_VideoDimension.getWidth(), (int)TimestampMovieSampler.this.m_VideoDimension.getHeight(), 1);
            TimestampMovieSampler.this.m_CurrentImage = new BufferedImageContainer();
            TimestampMovieSampler.this.m_Image.setRGB(0, 0, (int)TimestampMovieSampler.this.m_VideoDimension.getWidth(), (int)TimestampMovieSampler.this.m_VideoDimension.getHeight(), rgbBuffer, 0, (int)TimestampMovieSampler.this.m_VideoDimension.getWidth());
            TimestampMovieSampler.this.m_CurrentImage.setImage((Object)TimestampMovieSampler.this.m_Image);
            long currentTime = directMediaPlayer.getTime();
            String ts = new BaseTimeMsec(new Date(currentTime)).getValue();
            if (ts.equals("-INF")) {
                ts = "00:00:00.000";
            }
            TimestampMovieSampler.this.m_CurrentImage.getReport().setValue((AbstractField)new Field("Timestamp", DataType.STRING), (Object)ts);
            if (currentTime == TimestampMovieSampler.this.m_TargetTime) {
                TimestampMovieSampler.this.m_Samples.add(TimestampMovieSampler.this.m_CurrentImage);
            }
        }
    }
}

