/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.flow.transformer.objecttracker.AbstractBoofCVObjectTracker;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class BoofCVSparseFlow
extends AbstractBoofCVObjectTracker {
    private static final long serialVersionUID = 7061565466109634695L;

    public String globalInfo() {
        return "Uses a pyramidal KLT tracker to track features inside the user selected region. The motion of the region is found robustly using LeastMedianOfSquares and a translation + rotation model. Drift is a problem since motion is estimated relative to the previous frame and it will eventually drift away from the original target. When it works well it is very smooth and can handle partially obscured objects. Can't recover after the target has been lost. Runs very fast.";
    }

    @Override
    protected TrackerObjectQuad newTracker() {
        switch (this.m_ImageType) {
            case FLOAT_32: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageFloat32.class, null);
            }
            case FLOAT_64: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageFloat64.class, null);
            }
            case SIGNED_INT_16: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageSInt16.class, null);
            }
            case SIGNED_INT_32: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageSInt32.class, null);
            }
            case SIGNED_INT_64: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageSInt64.class, null);
            }
            case SIGNED_INT_8: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageSInt8.class, null);
            }
            case UNSIGNED_INT_16: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageUInt16.class, null);
            }
            case UNSIGNED_INT_8: {
                return FactoryTrackerObjectQuad.sparseFlow(null, ImageUInt8.class, null);
            }
        }
        throw new IllegalStateException("Unhandled image type: " + this.m_ImageType);
    }
}

