/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.AbstractTrailReader;
import adams.data.io.input.SimpleTrailReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.AbstractTrailWriter;
import adams.data.io.output.SimpleTrailWriter;
import adams.data.trail.Trail;
import adams.gui.chooser.AbstractDataContainerFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.core.ExtensionFileFilter;
import java.io.File;
import java.util.List;

public class TrailFileChooser
extends AbstractDataContainerFileChooser<Trail, AbstractDataContainerReader<Trail>, AbstractDataContainerWriter<Trail>> {
    private static final long serialVersionUID = -5373058011025481738L;

    public TrailFileChooser() {
    }

    public TrailFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public TrailFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractDataContainerReader<Trail> getDefaultReader() {
        return new SimpleTrailReader();
    }

    protected AbstractDataContainerWriter<Trail> getDefaultWriter() {
        return new SimpleTrailWriter();
    }

    protected Class getReaderClass() {
        return AbstractTrailReader.class;
    }

    protected Class getWriterClass() {
        return AbstractTrailWriter.class;
    }

    protected void doInitializeFilters() {
        TrailFileChooser.initFilters((AbstractDataContainerFileChooser)this, (boolean)true, (String[])AbstractTrailReader.getReaders());
        TrailFileChooser.initFilters((AbstractDataContainerFileChooser)this, (boolean)false, (String[])AbstractTrailWriter.getWriters());
    }

    public AbstractDataContainerReader<Trail> getReaderForFile(File file) {
        AbstractDataContainerReader result = null;
        for (List list : m_ReaderFileFilters.values()) {
            for (ExtensionFileFilterWithClass filter : list) {
                if (TrailFileChooser.isAllFilter((ExtensionFileFilter)filter) || !filter.accept(file)) continue;
                try {
                    result = (AbstractDataContainerReader)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    TrailFileChooser.handleException((String)("Failed to instantiate reader: " + filter.getClassname()), (Throwable)e);
                }
            }
            if (result != null) continue;
            for (ExtensionFileFilterWithClass filter : list) {
                if (!TrailFileChooser.isAllFilter((ExtensionFileFilter)filter) || !filter.accept(file)) continue;
                try {
                    result = (AbstractDataContainerReader)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    TrailFileChooser.handleException((String)("Failed to instantiate reader: " + filter.getClassname()), (Throwable)e);
                }
            }
        }
        return result;
    }

    public AbstractDataContainerWriter<Trail> getWriterForFile(File file) {
        AbstractDataContainerWriter result = null;
        for (List list : m_WriterFileFilters.values()) {
            for (ExtensionFileFilterWithClass filter : list) {
                if (TrailFileChooser.isAllFilter((ExtensionFileFilter)filter) || !filter.accept(file)) continue;
                try {
                    result = (AbstractDataContainerWriter)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    TrailFileChooser.handleException((String)("Failed to instantiate writer: " + filter.getClassname()), (Throwable)e);
                }
            }
            if (result != null) continue;
            for (ExtensionFileFilterWithClass filter : list) {
                if (!TrailFileChooser.isAllFilter((ExtensionFileFilter)filter) || !filter.accept(file)) continue;
                try {
                    result = (AbstractDataContainerWriter)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    TrailFileChooser.handleException((String)("Failed to instantiate writer: " + filter.getClassname()), (Throwable)e);
                }
            }
        }
        return result;
    }
}

