/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.SimpleTrailReader;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.TrailDisplay;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.TrailFileReader;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import adams.gui.visualization.trail.paintlet.Circles;
import adams.gui.visualization.trail.paintlet.TrailPaintlet;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TrailDisplayTest
extends AbstractFlowTest {
    public TrailDisplayTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("mouse2.trail");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("mouse2.trail");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(TrailDisplayTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/mouse2.trail"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            TrailFileReader trailfilereader = new TrailFileReader();
            SimpleTrailReader simpletrailreader = new SimpleTrailReader();
            trailfilereader.setReader((AbstractDataContainerReader)simpletrailreader);
            actors.add(trailfilereader);
            TrailDisplay traildisplay = new TrailDisplay();
            NullWriter nullwriter = new NullWriter();
            traildisplay.setWriter((JComponentWriter)nullwriter);
            Circles circles = new Circles();
            traildisplay.setPaintlet((TrailPaintlet)circles);
            actors.add(traildisplay);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            TrailDisplayTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TrailDisplayTest.runTest((Test)TrailDisplayTest.suite());
    }
}

