/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.io.input.AbstractDataContainerReaderTestCase;
import adams.data.io.input.AbstractTrailReader;
import adams.data.trail.Trail;
import adams.test.TmpFile;
import java.util.List;

public abstract class AbstractTrailReaderTestCase
extends AbstractDataContainerReaderTestCase<AbstractTrailReader, Trail> {
    public AbstractTrailReaderTestCase(String name) {
        super(name);
    }

    protected boolean save(List<Trail> data, String filename, int[] ignored) {
        StringBuilder content = new StringBuilder();
        for (Trail d : data) {
            content.append("---\n");
            if (d.hasReport()) {
                String props = d.getReport().toProperties().toComment();
                String[] lines = Utils.split((String)props, (String)"\n");
                for (int i = 1; i < lines.length; ++i) {
                    if (i > 1) {
                        content.append("\n");
                    }
                    content.append(lines[i]);
                }
            }
            content.append("Background: " + d.hasBackground() + "\n");
            if (d.hasBackground()) {
                content.append("Background dimensions: " + d.getBackground().getWidth() + "x" + d.getBackground().getHeight() + "\n");
            }
            content.append(d.toSpreadSheet().toString());
            content.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)content, (boolean)false);
    }
}

