/*
 * Decompiled with CFR 0.152.
 */
package adams.data.trail;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;
import java.util.Date;
import java.util.HashMap;

public class Step
extends AbstractDataPoint {
    private static final long serialVersionUID = 7649750314026526010L;
    protected Date m_Timestamp;
    protected float m_X;
    protected float m_Y;
    protected HashMap<String, Object> m_MetaData;
    protected static DateFormat m_Format;

    public Step() {
        this(new Date(), 0.0f, 0.0f);
    }

    public Step(Date timestamp, float x, float y) {
        this(timestamp, x, y, null);
    }

    public Step(Date timestamp, float x, float y, HashMap<String, Object> metaData) {
        this.m_Timestamp = new Date(timestamp.getTime());
        this.m_X = x;
        this.m_Y = y;
        this.m_MetaData = null;
        if (metaData != null) {
            this.m_MetaData = new HashMap<String, Object>(metaData);
        }
    }

    protected static synchronized DateFormat getFormat() {
        if (m_Format == null) {
            m_Format = DateUtils.getTimestampFormatterMsecs();
        }
        return m_Format;
    }

    public void assign(DataPoint other) {
        super.assign(other);
        Step step = (Step)other;
        this.setTimestamp(step.getTimestamp());
        this.setX(step.getX());
        this.setY(step.getY());
        this.setMetaData(step.getMetaData());
    }

    public void setTimestamp(Date value) {
        this.m_Timestamp = new Date(value.getTime());
    }

    public Date getTimestamp() {
        return this.m_Timestamp;
    }

    public void setX(float value) {
        this.m_X = value;
    }

    public float getX() {
        return this.m_X;
    }

    public void setY(float value) {
        this.m_Y = value;
    }

    public float getY() {
        return this.m_Y;
    }

    public boolean hasMetaData() {
        return this.m_MetaData != null && this.m_MetaData.size() > 0;
    }

    public void setMetaData(HashMap<String, Object> value) {
        this.m_MetaData = value == null ? null : new HashMap<String, Object>(value);
    }

    public HashMap<String, Object> getMetaData() {
        return this.m_MetaData;
    }

    public synchronized void addMetaData(String key, Object value) {
        if (this.m_MetaData == null) {
            this.m_MetaData = new HashMap();
        }
        this.m_MetaData.put(key, value);
    }

    public int compareTo(Object o) {
        Step other = (Step)((Object)o);
        int result = this.getTimestamp().compareTo(other.getTimestamp());
        if (result == 0) {
            result = new Float(this.getX()).compareTo(Float.valueOf(other.getX()));
        }
        if (result == 0) {
            result = new Float(this.getY()).compareTo(Float.valueOf(other.getY()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Step && this.compareTo(obj) == 0;
    }

    public String toString() {
        return Step.getFormat().format(this.m_Timestamp) + ": x=" + this.m_X + " y=" + this.m_Y + (this.hasMetaData() ? this.getMetaData().toString() : "");
    }
}

