/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.trail.Trail;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.awt.image.BufferedImage;

public class AddTrailBackground
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected CallableActorReference m_Background;

    public String globalInfo() {
        return "Adds a step tp the trail passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background", "background", (Object)new CallableActorReference("unknown"));
    }

    public void setBackground(CallableActorReference value) {
        this.m_Background = value;
        this.reset();
    }

    public CallableActorReference getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The callable actor to obtain the background image from (" + BufferedImage.class.getName() + " or " + AbstractImageContainer.class.getName() + ")";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"background", (Object)this.m_Background, (String)"background: ");
    }

    public Class[] accepts() {
        return new Class[]{Trail.class};
    }

    public Class[] generates() {
        return new Class[]{Trail.class};
    }

    protected BufferedImage getBackgroundInstance() {
        BufferedImage result = null;
        MessageCollection errors = new MessageCollection();
        Object obj = CallableActorHelper.getSetupFromSource(Object.class, (CallableActorReference)this.m_Background, (Actor)this, (MessageCollection)errors);
        if (obj == null) {
            if (!errors.isEmpty()) {
                this.getLogger().severe(errors.toString());
            }
        } else if (obj instanceof BufferedImage) {
            result = (BufferedImage)obj;
        } else if (obj instanceof AbstractImageContainer) {
            result = ((AbstractImageContainer)obj).toBufferedImage();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Trail trail = (Trail)((Object)this.m_InputToken.getPayload());
        BufferedImage background = this.getBackgroundInstance();
        if (background != null) {
            trail.setBackground(background);
        } else {
            result = "Failed to obtain image from '" + this.m_Background + "'!";
        }
        this.m_OutputToken = new Token((Object)trail);
        return result;
    }
}

