/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseURL;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class MjpegImageSequence
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected transient SimpleImageSequence m_Video;
    protected OutputType m_OutputType;
    protected int m_MaxImages;
    protected int m_Count;

    public String globalInfo() {
        return "Streams the individual frames from the MJPEG video file obtained as input.\nImages are output as " + ImageFloat32.class.getName() + " (" + (Object)((Object)OutputType.FRAME) + ") or " + BufferedImage.class.getName() + " (" + (Object)((Object)OutputType.GUIIMAGE) + ").\nIn case of output type " + (Object)((Object)OutputType.BOTH) + ", an array of frame (first) and GUI image (second) is output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.GUIIMAGE);
        this.m_OptionManager.add("max-images", "maxImages", (Object)-1, (Number)-1, null);
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The output type: frame, GUI image or both.";
    }

    public void setMaxImages(int value) {
        if (this.getOptionManager().isValid("maxImages", (Number)value)) {
            this.m_MaxImages = value;
            this.reset();
        }
    }

    public int getMaxImages() {
        return this.m_MaxImages;
    }

    public String maxImagesTipText() {
        return "The maximum number of images to extract; -1 for all.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"outputType", (Object)((Object)this.m_OutputType), (String)"output: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxImages", (Object)(this.m_MaxImages <= 0 ? "all" : "" + this.m_MaxImages), (String)", # of images: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, BaseURL.class};
    }

    public Class[] generates() {
        switch (this.m_OutputType) {
            case FRAME: {
                return new Class[]{BoofCVImageContainer.class};
            }
            case GUIIMAGE: {
                return new Class[]{BufferedImageContainer.class};
            }
            case BOTH: {
                return new Class[]{AbstractImageContainer[].class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
    }

    protected String doExecute() {
        String result = null;
        this.m_Count = 0;
        Object payload = this.m_InputToken.getPayload();
        if (payload instanceof String || payload instanceof File) {
            String filename = payload instanceof String ? (String)payload : ((File)payload).getAbsolutePath();
            PlaceholderFile file = new PlaceholderFile(filename);
            try {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List data = codec.read((InputStream)new FileInputStream(file.getAbsolutePath()));
                this.m_Video = new JpegByteImageSequence(ImageFloat32.class, data, false);
            }
            catch (Exception e) {
                result = this.handleException("Failed to open video file: " + payload, e);
            }
        } else if (payload instanceof BaseURL) {
            try {
                URL url = ((BaseURL)payload).urlValue();
                URLConnection conn = url.openConnection();
                if (url.getUserInfo() != null) {
                    String basicAuth = "Basic " + new String(new Base64().encode(url.getUserInfo().getBytes()));
                    conn.setRequestProperty("Authorization", basicAuth);
                }
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List data = codec.read(conn.getInputStream());
                this.m_Video = new JpegByteImageSequence(ImageFloat32.class, data, false);
            }
            catch (Exception e) {
                result = this.handleException("Failed to open video stream: " + payload, e);
            }
        } else {
            result = "Unhandled input type: " + Utils.classToString((Object)payload);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Video != null && this.m_Video.hasNext();
    }

    public Token output() {
        ImageBase frame = this.m_Video.next();
        Field field = new Field("Frame", DataType.NUMERIC);
        BufferedImageContainer bicont = null;
        BoofCVImageContainer boofcont = null;
        if (this.m_OutputType == OutputType.BOTH || this.m_OutputType == OutputType.FRAME) {
            boofcont = new BoofCVImageContainer();
            boofcont.setImage((Object)frame);
            boofcont.getReport().addField((AbstractField)field);
            boofcont.getReport().setValue((AbstractField)field, (Object)this.m_Video.getFrameNumber());
        }
        if (this.m_OutputType == OutputType.BOTH || this.m_OutputType == OutputType.GUIIMAGE) {
            bicont = new BufferedImageContainer();
            bicont.setImage((Object)((BufferedImage)this.m_Video.getGuiImage()));
            bicont.getReport().addField((AbstractField)field);
            bicont.getReport().setValue((AbstractField)field, (Object)this.m_Video.getFrameNumber());
        }
        Token result = boofcont != null && bicont != null ? new Token((Object)new AbstractImageContainer[]{boofcont, bicont}) : (boofcont != null ? new Token((Object)boofcont) : new Token((Object)bicont));
        ++this.m_Count;
        if (this.m_MaxImages > 0 && this.m_Count >= this.m_MaxImages) {
            this.m_Video = null;
        }
        return result;
    }

    public static enum OutputType {
        FRAME,
        GUIIMAGE,
        BOTH;

    }
}

