/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.movieimagesampler.AbstractMovieImageSampler;
import adams.flow.transformer.movieimagesampler.FixedIntervalBufferedImageSampler;
import java.io.File;
import java.util.Arrays;

public class MovieImageSampler
extends AbstractArrayProvider {
    private static final long serialVersionUID = 3690378527551302472L;
    protected AbstractMovieImageSampler m_Sampler;

    public String globalInfo() {
        return "Outputs sample images from a movie file generated by the specified sampler algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sampler", "sampler", (Object)new FixedIntervalBufferedImageSampler());
    }

    public String outputArrayTipText() {
        return "If enabled, the sample images get output as array rather than one-by-one.";
    }

    public void setSampler(AbstractMovieImageSampler value) {
        this.m_Sampler = value;
        this.reset();
    }

    public AbstractMovieImageSampler getSampler() {
        return this.m_Sampler;
    }

    public String samplerTipText() {
        return "The sampler algorithm to use for generating the sample images from the movie.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"sampler", (Object)((Object)this.m_Sampler));
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected Class getItemClass() {
        return this.m_Sampler.generates();
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        try {
            AbstractImageContainer[] samples = this.m_Sampler.sample((File)file);
            if (samples != null) {
                this.m_Queue.addAll(Arrays.asList(samples));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to sample movie file: " + file, e);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Sampler != null) {
            this.m_Sampler.stopExecution();
        }
        super.stopExecution();
    }
}

