/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.movieimagesampler;

import adams.core.base.BaseTimeMsec;
import adams.data.image.BufferedImageContainer;
import adams.flow.transformer.movieimagesampler.AbstractBufferedImageMovieImageSampler;
import adams.gui.visualization.video.vlcjplayer.VideoUtilities;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.condition.conditions.PausedCondition;
import uk.co.caprica.vlcj.player.condition.conditions.PlayingCondition;
import uk.co.caprica.vlcj.player.condition.conditions.TimeReachedCondition;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.direct.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;

public class FixedIntervalBufferedImageSamplerVlcj
extends AbstractBufferedImageMovieImageSampler {
    private static final long serialVersionUID = -577020017132279115L;
    protected int m_NumSamples;
    protected BaseTimeMsec m_Offset;
    protected int m_Interval;
    protected DirectMediaPlayer m_MediaPlayer;
    protected List<BufferedImageContainer> m_Samples;
    protected MediaPlayerFactory m_Factory;
    protected Dimension m_VideoDimension;
    protected BufferedImage m_Image;
    protected BufferedImageContainer m_CurrentImage;
    protected BufferedImageContainer m_PreviousImage;
    private long m_TargetTime;

    public String globalInfo() {
        return "Generates a specified number of image samples at fixed intervals.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("offset", "offset", (Object)new BaseTimeMsec("-INF"));
        this.m_OptionManager.add("interval", "interval", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("num-samples", "numSamples", (Object)10, (Number)1, null);
    }

    public void setOffset(BaseTimeMsec value) {
        this.m_Offset = value;
        this.reset();
    }

    public BaseTimeMsec getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset for the samples, i.e., before starting the sampling.";
    }

    public void setInterval(int value) {
        if (this.getOptionManager().isValid("interval", (Number)value)) {
            this.m_Interval = value;
            this.reset();
        }
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval in milli-seconds between samples.";
    }

    public void setNumSamples(int value) {
        if (this.getOptionManager().isValid("numSamples", (Number)value)) {
            this.m_NumSamples = value;
            this.reset();
        }
    }

    public int getNumSamples() {
        return this.m_NumSamples;
    }

    public String numSamplesTipText() {
        return "The number of samples to take.";
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImage = new BufferedImageContainer();
        this.m_PreviousImage = new BufferedImageContainer();
    }

    protected BufferedImageContainer[] doSample(final File file) {
        this.m_VideoDimension = VideoUtilities.getVideoDimensions(file.getAbsolutePath());
        this.m_Image = new BufferedImage((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight(), 1);
        this.m_Factory = new MediaPlayerFactory();
        BufferFormatCallback bufferFormatCallback = (i, i1) -> new RV32BufferFormat((int)this.m_VideoDimension.getWidth(), (int)this.m_VideoDimension.getHeight());
        this.m_MediaPlayer = this.m_Factory.newDirectMediaPlayer(bufferFormatCallback, (RenderCallback)new SnapshotRenderCallback());
        this.m_Samples = new ArrayList<BufferedImageContainer>();
        try {
            PlayingCondition playingCondition = new PlayingCondition((MediaPlayer)this.m_MediaPlayer){

                protected boolean onBefore() {
                    return FixedIntervalBufferedImageSamplerVlcj.this.m_MediaPlayer.startMedia(file.getAbsolutePath(), new String[0]);
                }
            };
            playingCondition.await();
            this.m_TargetTime = 0L;
            for (int i2 = 0; i2 < this.m_NumSamples; ++i2) {
                TimeReachedCondition timeReachedCondition = new TimeReachedCondition((MediaPlayer)this.m_MediaPlayer, this.m_TargetTime){

                    protected boolean onBefore() {
                        FixedIntervalBufferedImageSamplerVlcj.this.m_MediaPlayer.setTime(this.targetTime);
                        return true;
                    }
                };
                timeReachedCondition.await();
                PausedCondition pausedCondition = new PausedCondition((MediaPlayer)this.m_MediaPlayer){

                    protected boolean onBefore() {
                        FixedIntervalBufferedImageSamplerVlcj.this.m_MediaPlayer.pause();
                        return true;
                    }
                };
                pausedCondition.await();
                playingCondition = new PlayingCondition((MediaPlayer)this.m_MediaPlayer){

                    protected boolean onBefore() {
                        FixedIntervalBufferedImageSamplerVlcj.this.m_MediaPlayer.play();
                        return true;
                    }
                };
                playingCondition.await();
                this.m_TargetTime += (long)this.m_Interval;
                if (this.m_TargetTime <= this.m_MediaPlayer.getLength()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_MediaPlayer.release();
        this.m_Factory.release();
        return this.m_Samples.toArray(new BufferedImageContainer[this.m_Samples.size()]);
    }

    private class SnapshotRenderCallback
    extends RenderCallbackAdapter {
        SnapshotRenderCallback() {
            super(new int[(int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getWidth() * (int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getHeight()]);
        }

        protected void onDisplay(DirectMediaPlayer directMediaPlayer, int[] rgbBuffer) {
            FixedIntervalBufferedImageSamplerVlcj.this.m_Image = new BufferedImage((int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getWidth(), (int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getHeight(), 1);
            FixedIntervalBufferedImageSamplerVlcj.this.m_CurrentImage = new BufferedImageContainer();
            FixedIntervalBufferedImageSamplerVlcj.this.m_Image.setRGB(0, 0, (int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getWidth(), (int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getHeight(), rgbBuffer, 0, (int)FixedIntervalBufferedImageSamplerVlcj.this.m_VideoDimension.getWidth());
            FixedIntervalBufferedImageSamplerVlcj.this.m_CurrentImage.setImage((Object)FixedIntervalBufferedImageSamplerVlcj.this.m_Image);
            long currentTime = directMediaPlayer.getTime();
            System.out.println("\nTIME: " + currentTime + "\n");
            if (currentTime == FixedIntervalBufferedImageSamplerVlcj.this.m_TargetTime) {
                FixedIntervalBufferedImageSamplerVlcj.this.m_Samples.add(FixedIntervalBufferedImageSamplerVlcj.this.m_CurrentImage);
            } else if (currentTime > FixedIntervalBufferedImageSamplerVlcj.this.m_TargetTime) {
                FixedIntervalBufferedImageSamplerVlcj.this.m_Samples.add(FixedIntervalBufferedImageSamplerVlcj.this.m_PreviousImage);
            }
            FixedIntervalBufferedImageSamplerVlcj.this.m_PreviousImage = new BufferedImageContainer();
            FixedIntervalBufferedImageSamplerVlcj.this.m_PreviousImage.setImage((Object)((BufferedImage)FixedIntervalBufferedImageSamplerVlcj.this.m_CurrentImage.getImage()));
        }
    }
}

