/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.data.container.DataPoint;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Step;
import adams.data.trail.Trail;
import adams.flow.core.RunnableWithLogging;
import adams.gui.visualization.annotator.AnnotationEvent;
import adams.gui.visualization.annotator.AnnotationListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventQueue
implements AnnotationListener {
    public static final long SLEEP_TIME = 4000L;
    protected ConcurrentLinkedQueue<Step> m_Steps;
    protected Trail m_Trail = new Trail();
    protected RunnableWithLogging m_Runnable;
    protected boolean m_Playing = false;

    public EventQueue() {
        this.m_Steps = new ConcurrentLinkedQueue();
        this.start();
    }

    public void resetTrail() {
        this.clearQueue();
        this.m_Trail = new Trail();
    }

    public Trail getTrail() {
        return this.m_Trail;
    }

    public void loadTrail(Trail trail) {
        this.m_Trail = trail;
        this.clearQueue();
    }

    protected void clearQueue() {
        this.m_Steps.clear();
    }

    protected void start() {
        this.m_Runnable = new RunnableWithLogging(){

            protected void doRun() {
                while (!this.m_Stopped) {
                    if (EventQueue.this.m_Steps.peek() == null) {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    Step step = EventQueue.this.m_Steps.poll();
                    Step oldStep = EventQueue.this.m_Trail.getStep(step.getTimestamp());
                    if (oldStep != null && oldStep.hasMetaData()) {
                        step.getMetaData().putAll(oldStep.getMetaData());
                    }
                    EventQueue.this.m_Trail.add((DataPoint)step);
                }
            }
        };
        Thread t = new Thread((Runnable)this.m_Runnable);
        t.start();
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Trail.toSpreadSheet();
    }

    @Override
    public void annotationOccurred(AnnotationEvent e) {
        this.m_Steps.add(e.getStep());
    }

    public void cleanUp() {
        this.m_Runnable.stopExecution();
    }

    public void setBackgroundImage(BufferedImage backgroundImage) {
        this.m_Trail.setBackground(backgroundImage);
    }

    public BufferedImage getBackgroundImage() {
        return this.m_Trail.getBackground();
    }
}

