/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import adams.data.image.multiimageoperation.Median;
import adams.flow.transformer.movieimagesampler.AbstractBufferedImageMovieImageSampler;
import adams.flow.transformer.movieimagesampler.AbstractMovieImageSampler;
import adams.flow.transformer.movieimagesampler.FixedIntervalBufferedImageSampler;
import adams.gui.core.BaseButton;
import adams.gui.core.MouseUtils;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ExtractBackgroundDialog
extends ApprovalDialog {
    private static final long serialVersionUID = 9156143578421221640L;
    protected AbstractBufferedImageMovieImageSampler m_ImageSampler;
    protected AbstractBufferedImageMultiImageOperation m_ImageOperation;
    protected BaseButton m_ButtonPreview;
    protected ImagePanel m_ImagePanel;
    protected GenericObjectEditorPanel m_ImageSamplerSelectionPanel;
    protected GenericObjectEditorPanel m_MultiImageOperationSelectionPanel;
    protected PlaceholderFile m_CurrentFile;
    protected BufferedImage m_Background;

    public ExtractBackgroundDialog(Dialog owner) {
        super(owner);
    }

    public ExtractBackgroundDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public ExtractBackgroundDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public ExtractBackgroundDialog(Dialog owner, String title, Dialog.ModalityType modality) {
        super(owner, title, modality);
    }

    public ExtractBackgroundDialog(Frame owner) {
        super(owner);
    }

    public ExtractBackgroundDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public ExtractBackgroundDialog(Frame owner, String title) {
        super(owner, title);
    }

    public ExtractBackgroundDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    protected void initGUI() {
        super.initGUI();
        this.setTitle("Extract background");
        ParameterPanel ppanel = new ParameterPanel();
        GenericObjectEditorPanel panel = new GenericObjectEditorPanel(AbstractMovieImageSampler.class, (Object)new FixedIntervalBufferedImageSampler(), true);
        ppanel.addParameter("Image Sampler", (Component)panel);
        this.m_ImageSamplerSelectionPanel = panel;
        this.m_ImageSampler = (AbstractBufferedImageMovieImageSampler)((Object)this.m_ImageSamplerSelectionPanel.getCurrent());
        this.m_ImageSamplerSelectionPanel.addChangeListener(e -> {
            this.m_ImageSampler = (AbstractBufferedImageMovieImageSampler)((Object)((Object)this.m_ImageSamplerSelectionPanel.getCurrent()));
        });
        panel = new GenericObjectEditorPanel(AbstractBufferedImageMultiImageOperation.class, (Object)new Median(), true);
        ppanel.addParameter("Image Operation", (Component)panel);
        this.m_MultiImageOperationSelectionPanel = panel;
        this.m_ImageOperation = (AbstractBufferedImageMultiImageOperation)this.m_MultiImageOperationSelectionPanel.getCurrent();
        this.m_MultiImageOperationSelectionPanel.addChangeListener(e -> {
            this.m_ImageOperation = (AbstractBufferedImageMultiImageOperation)this.m_MultiImageOperationSelectionPanel.getCurrent();
        });
        this.add((Component)ppanel, "North");
        this.m_ImagePanel = new ImagePanel();
        this.add((Component)this.m_ImagePanel, "Center");
        this.m_ButtonPreview = new BaseButton("Preview");
        this.getButtonsPanel(false).add((Component)this.m_ButtonPreview);
        this.getButtonsPanel(false).setComponentZOrder((Component)this.m_ButtonPreview, 0);
        this.m_ButtonPreview.addActionListener(e -> this.extractBackground());
    }

    public void setCurrentFile(PlaceholderFile file) {
        this.m_CurrentFile = file;
        this.m_Background = null;
        this.updateButtons();
    }

    public PlaceholderFile getCurrentFile() {
        return this.m_CurrentFile;
    }

    protected void extractBackground() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                MouseUtils.setWaitCursor((Component)((Object)ExtractBackgroundDialog.this));
                BufferedImageContainer[] imageContainers = (BufferedImageContainer[])ExtractBackgroundDialog.this.m_ImageSampler.sample((File)ExtractBackgroundDialog.this.m_CurrentFile);
                BufferedImageContainer bufferedImageContainer = ((BufferedImageContainer[])ExtractBackgroundDialog.this.m_ImageOperation.process((AbstractImageContainer[])imageContainers))[0];
                ExtractBackgroundDialog.this.m_Background = (BufferedImage)bufferedImageContainer.getImage();
                ExtractBackgroundDialog.this.m_ImagePanel.setCurrentImage(ExtractBackgroundDialog.this.m_Background);
                SwingUtilities.invokeLater(() -> ExtractBackgroundDialog.this.m_ImagePanel.setScale(-1.0));
                return null;
            }

            @Override
            protected void done() {
                super.done();
                MouseUtils.setDefaultCursor((Component)((Object)ExtractBackgroundDialog.this));
                ExtractBackgroundDialog.this.updateButtons();
            }
        };
        worker.execute();
    }

    public BufferedImage getBackgroundImage() {
        return this.m_Background;
    }

    protected void updateButtons() {
        this.m_ButtonApprove.setEnabled(this.m_Background != null);
    }
}

