/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail.paintlet;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.trail.Trail;
import adams.gui.visualization.image.paintlet.AbstractPaintlet;
import adams.gui.visualization.trail.TrailPanel;
import adams.gui.visualization.trail.paintlet.TrailPaintlet;
import java.awt.Color;
import java.awt.Graphics;

public abstract class AbstractTrailPaintlet
extends AbstractPaintlet
implements TrailPaintlet {
    private static final long serialVersionUID = 8036940792107897639L;
    protected TrailPanel m_TrailPanel;
    protected Color m_Color;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)this.getDefaultColor());
    }

    protected void initialize() {
        super.initialize();
        this.m_TrailPanel = null;
    }

    protected Color getDefaultColor() {
        return Color.RED;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public String colorTipText() {
        return "The stroke color.";
    }

    @Override
    public void setPanel(TrailPanel value) {
        this.m_TrailPanel = value;
        if (this.m_TrailPanel != null) {
            this.setPanel(this.m_TrailPanel.getImagePanel());
        }
    }

    @Override
    public TrailPanel getTrailPanel() {
        return this.m_TrailPanel;
    }

    @Override
    public abstract void paintData(Graphics var1, Trail var2);

    protected void performPaint(Graphics g) {
        if (this.getTrailPanel() == null) {
            return;
        }
        Trail trail = this.getTrailPanel().getTrail();
        if (trail != null) {
            this.paintData(g, trail);
        }
    }

    public static String[] getPaintlets() {
        return ClassLister.getSingleton().getClassnames(TrailPaintlet.class);
    }

    public static TrailPaintlet forName(String classname, String[] options) {
        TrailPaintlet result;
        try {
            result = (TrailPaintlet)OptionUtils.forName(TrailPaintlet.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static TrailPaintlet forCommandLine(String cmdline) {
        return (TrailPaintlet)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

