/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail.paintlet;

import adams.data.trail.Step;
import adams.data.trail.Trail;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.trail.paintlet.AbstractTrailPaintlet;
import java.awt.Graphics;
import java.util.List;

public class Circles
extends AbstractTrailPaintlet
implements AntiAliasingSupporter {
    private static final long serialVersionUID = 5930861236258148877L;
    protected int m_Diameter;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Simple paints the trail steps as circles.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("diameter", "diameter", (Object)7, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(this.getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setDiameter(int value) {
        this.m_Diameter = value;
        this.memberChanged();
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle in pixels.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing circles.";
    }

    @Override
    public void paintData(Graphics g, Trail trail) {
        List points = trail.toList();
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        for (int i = 0; i < points.size(); ++i) {
            Step curr = (Step)((Object)points.get(i));
            int currX = (int)curr.getX();
            int currY = (int)curr.getY();
            g.drawOval(currX -= this.m_Diameter / 2, currY -= this.m_Diameter / 2, this.m_Diameter - 1, this.m_Diameter - 1);
        }
    }
}

