/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail.paintlet;

import adams.data.trail.Step;
import adams.data.trail.Trail;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.trail.paintlet.AbstractTrailPaintlet;
import java.awt.Graphics;
import java.util.List;

public class Lines
extends AbstractTrailPaintlet
implements AntiAliasingSupporter {
    private static final long serialVersionUID = -2398989327548617860L;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Connects the step locations with lines.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(this.getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing circles.";
    }

    @Override
    public void paintData(Graphics g, Trail trail) {
        List points = trail.toList();
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        for (int i = 1; i < points.size(); ++i) {
            Step prev = (Step)((Object)points.get(i - 1));
            Step curr = (Step)((Object)points.get(i));
            int prevX = (int)prev.getX();
            int prevY = (int)prev.getY();
            int currX = (int)curr.getX();
            int currY = (int)curr.getY();
            g.drawLine(prevX, prevY, currX, currY);
        }
    }
}

