/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.trail.plugins;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.trail.TrailPanel;
import adams.gui.visualization.trail.TrailViewerPanel;
import adams.gui.visualization.trail.plugins.AbstractTrailViewerPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractSelectedTrailsViewerPlugin
extends AbstractTrailViewerPlugin {
    private static final long serialVersionUID = 869121794905442017L;
    protected TrailPanel[] m_SelectedPanels;

    public boolean canExecute(TrailPanel panel) {
        return panel != null && panel.getTrail() != null;
    }

    protected TrailPanel[] getAllPanels() {
        ArrayList<TrailPanel> result = new ArrayList<TrailPanel>();
        TrailViewerPanel owner = (TrailViewerPanel)((Object)GUIHelper.getParent((Container)this.m_CurrentPanel, TrailViewerPanel.class));
        if (owner != null) {
            result.addAll(Arrays.asList(owner.getAllPanels()));
        }
        return result.toArray(new TrailPanel[result.size()]);
    }

    protected JPanel createListPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        final TrailPanel[] panels = this.getAllPanels();
        DefaultListModel<String> model = new DefaultListModel<String>();
        int index = -1;
        for (TrailPanel p : panels) {
            if (p == this.m_CurrentPanel) {
                index = model.getSize();
            }
            model.addElement(model.getSize() + 1 + ": " + p.getTitle());
        }
        final JList list = new JList(model);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indices = list.getSelectedIndices();
                AbstractSelectedTrailsViewerPlugin.this.m_SelectedPanels = new TrailPanel[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    AbstractSelectedTrailsViewerPlugin.this.m_SelectedPanels[i] = panels[indices[i]];
                }
            }
        });
        list.setSelectedIndex(index);
        BaseScrollPane scrollPane = new BaseScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 1));
        result.add((Component)scrollPane, "Center");
        return result;
    }

    protected abstract JPanel createConfigurationPanel(ApprovalDialog var1);

    protected Dimension getDialogSize() {
        return GUIHelper.getDefaultSmallDialogDimension();
    }

    protected boolean hasApprovalButton() {
        return true;
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected ApprovalDialog createDialog() {
        ApprovalDialog result = ((TrailPanel)((Object)this.m_CurrentPanel)).getParentDialog() != null ? new ApprovalDialog(((TrailPanel)((Object)this.m_CurrentPanel)).getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(((TrailPanel)((Object)this.m_CurrentPanel)).getParentFrame(), true);
        result.setTitle(this.getCaption());
        result.setApproveVisible(this.hasApprovalButton());
        result.setCancelVisible(this.hasCancelButton());
        result.setDiscardVisible(false);
        result.setSize(this.getDialogSize());
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Please select:"));
        result.getContentPane().add((Component)panel, "North");
        panel = new JPanel(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        JPanel panelList = this.createListPanel(result);
        panelList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelConfig = this.createConfigurationPanel(result);
        if (panelConfig == null) {
            panel.add((Component)panelList, "Center");
        } else {
            panel.add((Component)panelList, "West");
            panel.add((Component)panelConfig, "Center");
        }
        return result;
    }

    protected String processInit() {
        return null;
    }

    protected abstract String process(TrailPanel var1);

    protected String processFinish() {
        return null;
    }

    protected String process() {
        String result = this.processInit();
        if (result == null) {
            TrailPanel panel;
            TrailPanel[] trailPanelArray = this.m_SelectedPanels;
            int n = trailPanelArray.length;
            for (int i = 0; i < n && (result = this.process(panel = trailPanelArray[i])) == null; ++i) {
            }
        }
        if (result == null) {
            result = this.processFinish();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        ApprovalDialog dialog = this.createDialog();
        if (dialog == null) {
            result = "Failed to create dialog!";
        } else {
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.getOption() == 0) {
                result = this.process();
            } else if (dialog.getOption() == 2) {
                this.m_CanceledByUser = true;
            }
        }
        return result;
    }
}

