/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.video.vlcjplayer;

import adams.gui.core.BasePanel;
import adams.gui.visualization.video.vlcjplayer.VideoUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import uk.co.caprica.vlcj.component.DirectMediaPlayerComponent;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.direct.RenderCallbackAdapter;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;

public class DirectRenderMediaPlayerPanel
extends BasePanel {
    protected int m_VideoWidth;
    protected int m_VideoHeight;
    protected DirectMediaPlayerComponent m_MediaComponent;
    protected BufferedImage m_Image;
    protected BufferFormatCallback m_BufferFormatCallback;

    protected void initGUI() {
        super.initGUI();
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
    }

    protected void initialize() {
        super.initialize();
    }

    protected void finishInit() {
        super.finishInit();
    }

    public void paint(Graphics g) {
        boolean resize = false;
        int x = 0;
        int y = 0;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int newWidth = this.getWidth();
        int newHeight = this.getHeight();
        double scaleW = (double)newWidth / (double)this.m_VideoWidth;
        double scaleH = (double)newHeight / (double)this.m_VideoHeight;
        double result = Math.min(scaleW, scaleH);
        double widthDiff = (double)newWidth - (double)this.m_VideoWidth * result;
        double heightDiff = (double)newHeight - (double)this.m_VideoHeight * result;
        if (resize) {
            x = (int)(widthDiff / 2.0);
            y = (int)(heightDiff / 2.0);
        }
        g2.scale(result, result);
        g2.drawImage(this.m_Image, null, x, y);
    }

    public void open(String fileName) {
        Dimension d = VideoUtilities.getVideoDimensions(fileName);
        this.m_VideoHeight = (int)d.getHeight();
        this.m_VideoWidth = (int)d.getWidth();
        this.m_Image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.m_VideoWidth, this.m_VideoHeight);
        this.m_BufferFormatCallback = (i, i1) -> new RV32BufferFormat(this.m_VideoWidth, this.m_VideoHeight);
        this.m_MediaComponent = new DirectMediaPlayerComponent(this.m_BufferFormatCallback){

            protected RenderCallback onGetRenderCallback() {
                return new VideoPlayerRenderCallbackAdapter();
            }
        };
        this.m_MediaComponent.getMediaPlayer().prepareMedia(fileName, new String[0]);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void setRate(float rate) {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().setRate(rate);
    }

    public void setPosition(float v) {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().setPosition(v);
    }

    public float getRate() {
        if (this.m_MediaComponent == null) {
            return 1.0f;
        }
        return this.m_MediaComponent.getMediaPlayer().getRate();
    }

    public boolean isMute() {
        if (this.m_MediaComponent == null) {
            return false;
        }
        return this.m_MediaComponent.getMediaPlayer().isMute();
    }

    public float getPosition() {
        if (this.m_MediaComponent == null) {
            return 0.0f;
        }
        return this.m_MediaComponent.getMediaPlayer().getPosition();
    }

    public long getTime() {
        if (this.m_MediaComponent == null) {
            return 0L;
        }
        return this.m_MediaComponent.getMediaPlayer().getTime();
    }

    public long getLength() {
        if (this.m_MediaComponent == null) {
            return 0L;
        }
        return this.m_MediaComponent.getMediaPlayer().getLength();
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener mediaPlayerEventListener) {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().addMediaPlayerEventListener(mediaPlayerEventListener);
    }

    public void pause() {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().pause();
    }

    public void play() {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().play();
    }

    public void stop() {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().stop();
    }

    public void mute() {
        if (this.m_MediaComponent != null) {
            this.m_MediaComponent.getMediaPlayer().mute(true);
        }
    }

    public void unmute() {
        if (this.m_MediaComponent != null) {
            this.m_MediaComponent.getMediaPlayer().mute(false);
        }
    }

    public void prepareMedia(String absolutePath) {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.getMediaPlayer().prepareMedia(absolutePath, new String[0]);
    }

    public void release() {
        if (this.m_MediaComponent == null) {
            return;
        }
        this.m_MediaComponent.release();
        this.m_MediaComponent = null;
    }

    public boolean isPlaying() {
        if (this.m_MediaComponent == null) {
            return false;
        }
        return this.m_MediaComponent.getMediaPlayer().isPlaying();
    }

    private class VideoPlayerRenderCallbackAdapter
    extends RenderCallbackAdapter {
        public VideoPlayerRenderCallbackAdapter() {
            super(new int[DirectRenderMediaPlayerPanel.this.m_VideoWidth * DirectRenderMediaPlayerPanel.this.m_VideoHeight]);
        }

        protected void onDisplay(DirectMediaPlayer directMediaPlayer, int[] rgbBuffer) {
            DirectRenderMediaPlayerPanel.this.m_Image.setRGB(0, 0, DirectRenderMediaPlayerPanel.this.m_VideoWidth, DirectRenderMediaPlayerPanel.this.m_VideoHeight, rgbBuffer, 0, DirectRenderMediaPlayerPanel.this.m_VideoWidth);
            DirectRenderMediaPlayerPanel.this.repaint();
        }
    }
}

